package com.digiwin.mobile.mobileuibot.core.component.action;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.attendance.GeoLocation;
import com.digiwin.mobile.mobileuibot.core.component.attendance.Wifi;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.input.actionsheet.InputActionSheet;
import com.digiwin.mobile.mobileuibot.core.component.input.addersubstracter.AdderSubstracter;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeDistrict;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputEocSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.choosetaskprogress.ChooseTaskProgress;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.hidden.InputHidden;
import com.digiwin.mobile.mobileuibot.core.component.input.location.InputLocation;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.ocr.InputOcr;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.scan.InputScanMulti;
import com.digiwin.mobile.mobileuibot.core.component.input.scan.InputScanSingle;
import com.digiwin.mobile.mobileuibot.core.component.input.scan.standard.InputScan;
import com.digiwin.mobile.mobileuibot.core.component.input.sign.InputSign;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.InputGroupSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.InputSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.standardentry.ZtbCargoInfoEntry;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCard;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCardList;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.component.logistics.Logistics;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsData;
import com.digiwin.mobile.mobileuibot.core.component.progressbar.ProgressBar;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartFuzzySearch;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearch;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartSearch;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.List;
import java.util.Optional;

/**
 * <p>功能描述：针对<code>ActionSubmitParam</code>类的自定义JSON反序列化类，若有新的录入组件，则需要在此添加转换逻辑 </p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ActionSubmitParamJsonDeserializer
 * @Author: Zaregoto
 * @Date: 2021/6/21 16:56
 */
public class ActionSubmitParamJsonDeserializer extends JsonDeserializer<ActionSubmitParam> {

    private static final Logger logger = LoggerFactory.getLogger(ActionSubmitParamJsonDeserializer.class);

    @Override
    public ActionSubmitParam deserialize(JsonParser jsonParser,
                                         DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        logger.debug("ActionSubmitParamJsonDeserializer run to prehandle submitParam.params to component instance...");
        JsonNode node = jsonParser.getCodec().readTree(jsonParser);
        String id = Optional.ofNullable(node.get("id")).map(JsonNode::asText).orElse("");
        String schema = Optional.ofNullable(node.get("schema")).map(JsonNode::asText).orElse("");
        String mobilePath = Optional.ofNullable(node.get("mobilePath")).map(JsonNode::asText).orElse("");
        String type = Optional.ofNullable(node.get("type")).map(JsonNode::asText).orElse("");
        String originalType = type;
        if (type.startsWith("DW_")) {
            type = type.substring(3);
        }
        JsonNode nodeParams = node.get("params");
        if (null == nodeParams) {
            return new ActionSubmitParam(id, type, schema, mobilePath, null);
        }
        if (originalType.equalsIgnoreCase("DW_" + Card.COMPONENT_TYPE)) {
            // V2 版的card组件反序列化处理，V1版不能走此逻辑，因为结构不一样，如果走此逻辑会抛异常
            // V2：{params:{dataId:"",submitParams:[],rawData:[]}}，V1：{"params":{"dataId":"","data":[]}}
            // wjw FIXME: 2023/10/24 注意：不可写card组件的提交参数解析器，可能会影响之前任务卡提交。因为解析后走之前通用处理后会存入元数据中
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), new TypeReference<Card>() {
                    }));
        } else if (type.equalsIgnoreCase(EditCardList.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), EditCardList.class));
        } else if (type.equalsIgnoreCase(EditCard.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), EditCard.class));
        } else if (type.equalsIgnoreCase(InputSingleText.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputSingleText.class));
        } else if (type.equalsIgnoreCase(InputMultiText.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputMultiText.class));
        } else if (type.equalsIgnoreCase(ChooseTaskProgress.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), ChooseTaskProgress.class));
        } else if (type.equalsIgnoreCase(InputCalendar.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputCalendar.class));
        } else if (type.equalsIgnoreCase(InputNumeric.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputNumeric.class));
        } else if (type.equalsIgnoreCase(Attachment.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(),
                            new TypeReference<Attachment<AttachmentRawDataDigiwinAthena>>() {
                            }));
        } else if (type.equalsIgnoreCase(InputWindowSingleSelect.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputWindowSingleSelect.class));
        } else if (type.equalsIgnoreCase(InputSingleSelect.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputSingleSelect.class));
        } else if (type.equalsIgnoreCase(Picture.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), Picture.class));
        } else if (type.equals(InputActionSheet.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputActionSheet.class));
        } else if (type.equalsIgnoreCase(InputDateTimePicker.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputDateTimePicker.class));
        } else if (type.equalsIgnoreCase(InputSign.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputSign.class));
        } else if (type.equalsIgnoreCase(InputHidden.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputHidden.class));
        } else if (type.equalsIgnoreCase(InputSwitch.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputSwitch.class));
        } else if (type.equalsIgnoreCase(Field.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), Field.class));
        } else if (type.equalsIgnoreCase(InputWindowMultiSelect.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputWindowMultiSelect.class));
        } else if (type.equalsIgnoreCase(InputLocation.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputLocation.class));
        } else if (type.equalsIgnoreCase(InputScanSingle.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputScanSingle.class));
        } else if (type.equalsIgnoreCase(InputScanMulti.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputScanMulti.class));
        } else if (type.equalsIgnoreCase(InputOcr.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputOcr.class));
        } else if (type.equalsIgnoreCase(SmartSearch.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), SmartSearch.class));
        } else if (type.equalsIgnoreCase(SmartFuzzySearch.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), SmartFuzzySearch.class));
        } else if (type.equalsIgnoreCase(SmartPreciseSearch.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), SmartPreciseSearch.class));
        } else if (type.equalsIgnoreCase(ButtonSingleSelect.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), ButtonSingleSelect.class));

        } else if (type.equalsIgnoreCase(InputGroupSingleSelect.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputSingleSelect.class));

        } else if (type.equalsIgnoreCase(InputCascade.COMPONENT_TYPE)) {
            if (originalType.startsWith("DW_")) {
                // InputCascade组件 V2版 提交时，传递的是InputCascade对象
                return new ActionSubmitParam(id, type, schema, mobilePath,
                        JsonUtil.jsonStringToObject(nodeParams.toString(), InputCascade.class));
            } else {
                // InputCascade组件 V1版 提交时，传递的是List<InputCascadeData>对象
                return new ActionSubmitParam(id, type, schema, mobilePath,
                        JsonUtil.jsonStringToObject(nodeParams.toString(), List.class));
            }
        } else if (type.equalsIgnoreCase(Logistics.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    ModuleUtils.listMapToListObject(JsonUtil.jsonStringToObject(nodeParams.toString(),
                            List.class), LogisticsData.class));
        } else if (type.equalsIgnoreCase(CustomGroup.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), CustomGroup.class));
        } else if (type.equalsIgnoreCase(SingleSelectList.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), SingleSelectList.class));
        } else if (type.equalsIgnoreCase(MultiFunctionList.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), MultiFunctionList.class));
        } else if (type.equalsIgnoreCase(InputCascadeDistrict.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputCascadeDistrict.class));
        } else if (type.equalsIgnoreCase(ZtbCargoInfoEntry.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), List.class));
        } else if (type.equalsIgnoreCase(InputScan.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputScan.class));
        } else if (type.equalsIgnoreCase(PageButton.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), PageButton.class));
        } else if (type.equalsIgnoreCase(ProgressBar.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), ProgressBar.class));
        } else if (type.equalsIgnoreCase(AdderSubstracter.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), AdderSubstracter.class));
        } else if (type.equalsIgnoreCase(GeoLocation.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), GeoLocation.class));
        } else if (type.equalsIgnoreCase(Wifi.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), Wifi.class));
        } else if (type.equalsIgnoreCase(InputEocSelect.COMPONENT_TYPE)) {
            return new ActionSubmitParam(id, type, schema, mobilePath,
                    JsonUtil.jsonStringToObject(nodeParams.toString(), InputEocSelect.class));
        } else {
            return new ActionSubmitParam(id, type, schema, mobilePath, new Object());
        }
    }
}
