package com.digiwin.mobile.mobileuibot.core.component.action;

import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogSubmitResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;

import java.io.Serializable;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ActionSubmitResult
 * @Author: Zaregoto
 * @Date: 2021/5/21 19:46
 */
public class ActionSubmitResult implements Serializable {
    private static final long serialVersionUID = 6965025913000624544L;

    private Boolean completed = true;
    private String promptMsg;
    private Action action;

    public ActionSubmitResult() {
    }

    public ActionSubmitResult(Boolean completed) {
        this.completed = completed;
    }

    public ActionSubmitResult(Boolean completed, String promptMsg) {
        this.completed = completed;
        this.promptMsg = promptMsg;
    }

    /**
     * 废弃原因：
     * 前端逻辑如果我们给了action，则会忽略completed参数
     * 反之则会根据completed参数判断
     */
    @Deprecated
    public ActionSubmitResult(Boolean completed, Action action) {
        this.completed = completed;
        this.action = action;
    }

    /**
     * 废弃原因：
     * 前端逻辑如果我们给了action，则会忽略completed参数
     * 反之则会根据completed参数判断
     */
    @Deprecated
    public static ActionSubmitResult create(boolean completed, Action action) {
        return new ActionSubmitResult(completed, action);
    }

    public ActionSubmitResult(Action action) {
        this.action = action;
    }

    public static ActionSubmitResult create(Action action) {
        return new ActionSubmitResult(action);
    }

    public static ActionSubmitResult create(boolean completed, String promptMsg) {
        return new ActionSubmitResult(completed, promptMsg);
    }

    public Boolean getCompleted() {
        return completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public String getPromptMsg() {
        return promptMsg;
    }

    public void setPromptMsg(String promptMsg) {
        this.promptMsg = promptMsg;
    }

    public Action getAction() {
        return action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    /**
     * pcUibot任务引擎提交
     *
     * @param apiRequest
     * @return
     */
    public static ActionSubmitResult pcUiBotSubmit(ApiRequestSubmit apiRequest, DigiwinAtmcProxyService
            digiwinAtmcProxyService) {
        DigiwinAtmcBacklogSubmitResult atmcSubmitResult =
                digiwinAtmcProxyService.actionSubmit(apiRequest.getLocale(),
                        apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getRawData());
        if (null != atmcSubmitResult.getRequestData()) {
            String promptMessage =
                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "提交成功");
            return ActionSubmitResult.create(true, promptMessage);
        } else {
            return ActionSubmitResult.create(false, atmcSubmitResult.getErrorMessage());
        }
    }
}
