package com.digiwin.mobile.mobileuibot.core.component.action;

import java.util.Objects;

/**
 * <p>功能描述：移动端点击事件类型枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ActionTypeEnum
 * @Author: Zaregoto
 * @Date: 2021/5/20 14:50
 */
public enum ActionTypeEnum {

    /**
     * 仍在当前页面操作
     */
    ACTION_CURRENT_PAGE(0),
    /**
     * 全屏推入方式打开全新页面
     */
    OPEN_NEW_PAGE(1),
    /**
     * 重置当前操作
     */
    ACTION_RESET(10),

    /**
     * 打开APP基础页面
     */
    OPEN_BASE_NEW_PAGE(11),

    /**
     * 以页签形式打开
     */
    OPEN_TABS(12),

    /**
     * 打开新页面，将原页面参数提交给后端
     */
    OPEN_NEW_PAGE_AND_SUBMIT(13),

    /**
     * 底部弹窗方式打开新页面
     */
    OPEN_NEW_PAGE_FROM_BOTTOM(2),

    /**
     * 底部弹窗滑动特效方式打开新页面/兄弟详情
     */
    OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER(20),
    /**
     * 调用端上扫描
     */
    OPEN_NATIVE_SCAN(21),
    /**
     * 调用端上扫描包含OCR且默认为OCR识别
     */
    OPEN_NATIVE_SCAN_COTAIN_OCR(22),

    /**
     * 定制类型，主管查看人员状况切换页面
     */
    PERSONNEL_STATE_SWITCH_PAGE(2000),
    /**
     * 定制类型，card点击,以弹窗方式展示详情（可左右滑动）
     */
    CUSTOMIZE_POPUP_DISPLAYS_PAGE(2222),

    /**
     * 调用接口，成功后返回前一个页面并刷新
     */
    CALL_API(3),

    /**
     * 使用action中的rowData，返回前一个页面并刷新
     */
    BACK_REFRESH(30),

    /**
     * 调用接口，成功后跳转提交成功页面
     */
    CALL_API_OPEN_SUCCESS_PAGE(31),

    /**
     * 调用接口，成功后跳转到指定页面,在途宝新增车辆页面使用
     */
    CALL_API_OPEN_SPECIFY_PAGE(310),

    /**
     * 调用接口，成功后使用successMsg，并刷新当前页面
     */
    CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE(32),

    /**
     * 调用提交接口，后刷新当前页面
     */
    CALL_API_REFRESH_CURRENT_PAGE(33),

    /**
     * 仅调用提交接口
     */
    CALL_API_ONLY(34),

    /**
     * 调用提交接口，成功后返回前两个页面并刷新
     */
    CALL_API_BACK_TWO(35),

    /**
     * 调用提交接口，成功后返回首页
     */
    CALL_API_BACK_INDEX(36),

    /**
     * 列表数据类型提交，成功后返回前一个页面并刷新（需结合customGroup一起使用）
     */
    CALL_API_LIST(37),

    /**
     * 调用提交接口，成功后返回前三个页面
     */
    CALL_API_BACK_THREE(38),

    /**
     * 调用提交接口，成功后返回前三个页面并刷新
     */
    CALL_API_BACK_THREE_AND_FLUSH(381),

    /**
     * 提交失败后二次弹窗，前端获取不到之前提交的参数。
     * 所以，后端把提交参数放到rawData中，前端从rawData中获取提交数据，然后重新赋值，调用提交接口，成功后跳转提交成功页面
     */
    CALL_API_RAWDATA_OPEN_SUCCESS_PAGE(39),

    /**
     * 返回上一页（若用1的方式打开，则推回前一页；若用3的方式打开，则关闭底部弹窗）
     */
    BACK(4),

    /**
     * 返回上一页，并且将当前页面中监听到的数据回传给上一页
     */
    BACK_WITH_NOTIFIED_DATA(41),

    /**
     * 返回上一页，并且回到预设值
     */
    BACK_WITH_DEFAULT_DATA(42),

    /**
     * 端上保存，进入下一页
     */
    NEXT(43),

    /**
     * 提交给后端，进入下一页
     */
    CALL_API_NEXT(44),

    /**
     * 返回上一个页面，将选中的值消息传递到上一个页面的GroupCard组件中的(Card组件)里的isChangeValue为true的这个条目中进行更新
     */
    RETURN_AND_UPDATE(45),

    /**
     * 提交刷新当前页并刷新
     */
    REFRESH(400),
    /**
     *
     */
    REFRESH_LOCAL(4001),

    /**
     * 返回前一页并刷新
     */
    BACK_ONE_WITH_REFRESH(401),

    /**
     * 返回前一页并不刷新 -- pageButton跳转另一页面前端本地保存返回当前页面
     */
    BACK_ONE_WITH_NO_REFRESH(4011),

    /**
     * 返回前两页并刷新
     */
    BACK_TWO_WITH_REFRESH(402),

    /**
     * 返回前三页并刷新
     */
    BACK_THREE_WITH_REFRESH(403),

    /**
     * 返回首页并刷新
     */
    BACK_INDEX_WITH_REFRESH(404),

    /**
     * 优测第三个页面 后端保存后跳转下一个待检测的页面 并刷新上一页(优测第二个页面)
     */
    JUMP_NEXT_DATA_AND_REFRASH(410),

    /**
     * 返回上一页 并将页面录入的数据传递到上一页卡片列表的对应的卡片中
     */
    BACK_AND_TRANSFER_DATA_TO_PREFIX(411),
    /**
     * 整批提交下：跳转下一个兄弟card 并将页面录入的数据传递到上一页卡片列表的对应的卡片中
     */
    JUMP_NEXT_AND_TRANSFER_DATA_TO_PREFIX(412),
    /**
     * 代为报工 前端保存：将工时组件替换 并存储执行人清单数据  返回上一页
     */
    BACK_AND_TRANSFER_GROUP_DATA_TO_PREFIX(413),
    /**
     * 在当前页面弹出弹窗提示
     */
    SHOW_CONFIRM_POP(50),

    /**
     * 在当前页面弹出TOAST提示，之后不做其他操作
     */
    SHOW_TOAST(5),

    /**
     * 弹窗提示
     */
    POP_PROMPT(51),

    /**
     * 弹窗提示-司机二维码展示。此时Action的requestUrl为获取明细的接口地址
     */
    POP_PROMPT_REQUEST(52),

    /**
     * 于屏幕右侧滑出侧边界面，并展示明细。此时Action的requestUrl为获取明细的接口地址
     * 目前首页使用
     */
    OPEN_RIGHT_SLIP_PAGE(6),

    /**
     * 调用蓝牙打印
     */
    BLOOTH_PRINT(71),

    /**
     * 调用摄像头扫码
     */
    CAMERA_SCAN(72),

    /**
     * 顺时针旋转内容90度并全屏展示
     */
    ROTATE_CONTENT_CLOCKWISE_BY_90_DEGREE_INTO_FULL_SCREEN(81),

    /**
     * 逆时针旋转内容90度并全屏展示
     */
    ROTATE_CONTENT_COUNTERCLOCKWISE_BY_90_DEGREE_INTO_FULL_SCREEN(82),

    /**
     * 用APP的webview打开网页
     */
    OPEN_WEB_PAGE(9),

    /**
     * 用APP的webview打开全屏网页
     */
    OPEN_FULL_SCREEN_WEB_PAGE(91),

    /**
     * 提交时候使用，前端控制组件效验提示信息
     */
    CONTROL_COMPONENT_VALIDATION_PROMPT(61),

    /**
     * 重置按钮
     */
    RESET(8),

    /**
     * 打开"我的"
     */
    OWN(10002),
    /**
     * 定制类型:打开全局资讯页面 --- MongoDB中配置此type
     */
    GLOBAL_INFORMATION(10003),

    /**
     * 管理
     */
    JUMP_MANAGE(10004),

    /**
     * 查看更多
     */
    JUMP_SEE_MORE(10005),


    /**
     * 全部导出
     */
    OPEN_NEW_PAGE_FROM_EXPORT_ALL(10006),

    /**
     * 部分导出
     */
    OPEN_NEW_PAGE_FROM_EXPORT(10007),

    /**
     * 导入
     */
    OPEN_NEW_PAGE_FROM_IMPORT(10008),

    /**
     * 下载模板
     */
    OPEN_NEW_PAGE_FROM_DOWNLOAD(10009),

    /**
    * 人员头像跳转通讯录人员详情页面
    */
    OPEN_NEW_PAGE_FROM_EOCID(10010),

    ;

    private Integer value;

    ActionTypeEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static ActionTypeEnum getEnumByValue(Integer value) {
        for (ActionTypeEnum testedEnum : ActionTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}