package com.digiwin.mobile.mobileuibot.core.component.action;

import java.util.Objects;

/**
 * <p>功能描述：APP本地基础页面名称枚举(配置action.type=ActionTypeEnum.OPEN_BASE_NEW_PAGE时使用）</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppBasePageNameEnum
 * @Author: zaregoto
 * @Date: 2023/12/19 14:00
 */
public enum AppBasePageNameEnum {
    /**
     * APP端搜索页面
     */
    APP_SEARCH("APP_SEARCH"),

    /**
     * 仅和端上定义，为扫描司机码
     */
    MOBILE_ZTB_DRIVER_CAR_QR_CODE("MOBILE_ZTB_DRIVER_CAR_QR_CODE"),

    /**
     * 敏捷数据详情页面
     */
    AGILE_DATA_DETAIL("AGILE_DATA_DETAIL"),

    /**
     * 敏捷数据-数据订阅详情页面
     */
    AGILE_DATA_SUBSCRIPTION_DETAIL("AGILE_DATA_SUBSCRIPTION_DETAIL"),

    /**
     * 智能助理聊天页面
     */
    AI_ASSISTANT("AI_ASSISTANT"),
    ;

    private final String value;

    AppBasePageNameEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static AppBasePageNameEnum getEnumByValue(String value) {
        for (AppBasePageNameEnum testedEnum : AppBasePageNameEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
