package com.digiwin.mobile.mobileuibot.core.component.action;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 业务数据类
 * 后端需要使用的业务字段，前端透传此对象给到后端使用
 *
 * @author yanfeng
 * @date 2024/4/23
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BusinessRawData {
    /**
     * 目前使用场景：CardList 筛选页面pageId
     */
    private String currentPageId;
    /**
     * cardList组件的唯一标识  --- 现前端获取此值自动传入请求的rawdata中
     * 注意：现只在 cardList筛选场景使用
     */
    private String componentId;
    /**
     * 移动任务卡/数据录入/发起项目/项目卡数据id
     */
    private String mobileDataId;
    /**
     * 关卡名称
     */
    private String tmActivityId;
    /**
     * 需要刷新的页面id
     */
    private String refreshPageId;
}