package com.digiwin.mobile.mobileuibot.core.component.action;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 新的二次弹窗提示
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ConfirmPop implements Serializable {
    private static final long serialVersionUID = -304742292233436413L;

    /**
     * 确认弹窗内容
     */
    private String content;
    /**
     * 是否需要确认
     */
    private Boolean needConfirm;
    /**
     * 确认弹窗标题
     */
    private String title;
    /**
     * 比较的内容
     */
    private String compareContent;
    /**
     * 比较的schema
     */
    private String compareSchema;
    /**
     * 是否需要校验的schema(对应开关类型等boolen)
     */
    private String checkedSchema;

    /**
     * 是否只展示确认按钮
     */
    private Boolean onlyConfirmButton;

    public static ConfirmPop create(String content, boolean needConfirm) {
        ConfirmPop confirmPop = new ConfirmPop();
        confirmPop.setContent(content);
        confirmPop.setNeedConfirm(needConfirm);
        return confirmPop;
    }

    public static ConfirmPop create(String title, String content, boolean needConfirm) {
        ConfirmPop confirmPop = new ConfirmPop();
        confirmPop.setTitle(title);
        confirmPop.setContent(content);
        confirmPop.setNeedConfirm(needConfirm);
        return confirmPop;
    }
}
