package com.digiwin.mobile.mobileuibot.core.component.action;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>功能描述：鼎捷uibot中action提交时需要的参数对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinActionSubmitParas.java
 * @Author: wangjwc
 * @Date: created at 2023/11/10 14:48
 */
@Data
@Accessors(chain = true)
public class DigiwinActionSubmitParas implements Serializable {
    private static final long serialVersionUID = -3449102436101054402L;

    /**
     * schema是鼎捷uibot中action提交时需要的参数key
     */
    private String schema;
    /**
     * schema全路径
     */
    private String mobilePath;
    /**
     * value是这个schema对应的值
     */
    private Object value;

    public DigiwinActionSubmitParas(String schema, String mobilePath, Object value) {
        this.schema = schema;
        this.mobilePath = mobilePath;
        this.value = value;
    }

    /**
     * 获取schema，如果是路径结构，则只返回当前字段
     *
     * @return
     */
    public String getSchema() {
        if (schema == null) {
            return schema;
        }
        if (!schema.contains(".")) {
            return schema;
        }
        String[] split = schema.split("\\.");
        return split[split.length - 1];
    }

    public String getOriginalSchema() {
        return this.schema;
    }
}
