package com.digiwin.mobile.mobileuibot.core.component.action.approval;

import lombok.Getter;

import java.util.Objects;

/**
 * <p>功能描述：签核任务按钮名称枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ApprovalActionNameEnum
 * @Author: Liux
 * @Date: 2022年10月8日 16点01分
 */
@Getter
public enum ApprovalActionNameEnum {

    /**
     * 提交
     */
    APPROVAL_DISPATCH("dispatch"),

    /**
     * 同意
     */
    APPROVAL_AGREE("agree"),

    /**
     * 转派
     */
    APPROVAL_REASSIGN("reassign"),

    /**
     * 退回重办
     */
    APPROVAL_REEXECUTE("reexecute"),

    /**
     * 加签
     */
    APPROVAL_ADD_TASK("add-task"),

    /**
     * 退回重签
     */
    APPROVAL_REAPPROVE("reapprove"),

    /**
     * 流程引擎-终止
     */
    APPROVAL_TERMINATE("terminate"),

    /**
     * 任务引擎-不同意、拒绝
     */
    APPROVAL_DISAGREE("disagree"),


    //----------------------流程引擎操作类型------------------------------
    // 提交 人工任务出现
    WORKFLOW_ACT_SUBMIT("workflow-act-submit"),
    // 同意 签核任务出现
    WORKFLOW_ACT_AGREE("workflow-act-agree"),
    // 不同意 签核任务出现
    WORKFLOW_ACT_DISAGREE("workflow-act-disagree"),
    // 加签 签核任务出现
    WORKFLOW_ACT_ADD("workflow-act-add"),
    // 退回 签核任务出现
    WORKFLOW_ACT_RETURN("workflow-act-return"),
    // 转派 签核任务出现
    WORKFLOW_ACT_REASSIGNMENT("workflow-act-reassignment"),
    // 数据录入-模型驱动-撤审按钮
    WORKFLOW_ABORT("workflow-abort"),

    ;

    private final String value;

    ApprovalActionNameEnum(String value) {
        this.value = value;
    }

    public static ApprovalActionNameEnum getEnumByValue(String value) {
        for (ApprovalActionNameEnum testedEnum : ApprovalActionNameEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
