package com.digiwin.mobile.mobileuibot.core.component.adaptivegrid;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.core.component.*;
import com.digiwin.mobile.mobileuibot.core.component.layout.ComponentLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.Data;


import java.io.Serializable;
import java.util.Map;

/**
 * 自适应网格组件
 */
@Data
public class GridGroup extends BaseGroupMobileComponent<BaseMobileComponent> implements Serializable {

    public static final String COMPONENT_TYPE = "GRID_GROUP";

    private static final long serialVersionUID = -6934090937492457034L;

    /**
     * 子项之间水平间距,默认“中”
     */
    private Integer itemHorizontalSpacing = GridSpacingEnum.MEDIUM.getValue();

    /**
     * 子项之间垂直间距,默认“中”
     */
    private Integer itemVerticalSpacing = GridSpacingEnum.MEDIUM.getValue();

    /**
     * 网格水平边缘间距,默认“中”
     */
    private Integer gridHorizontalMargin = GridSpacingEnum.MEDIUM.getValue();

    /**
     * 网格垂直边缘间距,默认“中”
     */
    private Integer gridVerticalMargin = GridSpacingEnum.MEDIUM.getValue();

    @Override
    public String returnComponentType() {
        return GridGroup.COMPONENT_TYPE;
    }

    @Override
    public ComponentLayoutTypeEnum getComponentLayoutType() {
        return ComponentLayoutTypeEnum.GRID;
    }

    /**
     * hooks以及容器内组件的构造
     *
     * @param cmptContext       组件构建中 上下文
     * @param mobilePath        schema的全路径字段
     * @param schema            待查找的schema字段
     * @param data              当前页面的数据源数据
     * @param executeContext    上下文信息
     * @param mobilePageRawData 原始数据
     */
    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        SpringContextHolder.getBean(UiBotDesignerRenderService.class).buildCmptDsl(cmptContext, executeContext, this.getContentGroup(), data, mobilePageRawData);
    }

}
