package com.digiwin.mobile.mobileuibot.core.component.address;

import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Address extends BaseInputMobileComponent implements Serializable {


    public static final String COMPONENT_TYPE = "ADDRESS";
    private static final long serialVersionUID = -739318707170613576L;

    /**
     * 主键
     */
    private String id;
    /**
     * 用户姓名
     */
    private String userId;
    /**
     * 姓名（收货人姓名，发货人姓名，物流信息等）
     */
    private String name;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 类型 0: 中间节点;1：发货人; 2：收货人
     */
    private Integer type;
    /**
     * 国家
     */
    private String country;
    /**
     * 省
     */
    private String province;
    /**
     * 市
     */
    private String city;
    private String areaId;
    private String adCode;
    /**
     * 区
     */
    private String area;
    /**
     * 街道
     */
    private String street;
    /**
     * 地址(小区名称+门牌号)
     */
    private String address;
    /**
     * 完整地址
     */
    private String completeAddress;

    /**
     * 操作按钮
     */
    private List<Button> editButtons;

    @Override

    public String returnComponentType() {
        return Address.COMPONENT_TYPE;
    }
}
