package com.digiwin.mobile.mobileuibot.core.component.apposition;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.address.Address;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbUserAddress;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 */
@Data
public class AppositionData implements Serializable {
    private static final long serialVersionUID = 5141477117853535638L;

    private Object data;
    private String componentType;

    public static AppositionData create(ZtbUserAddress userAddress, LocaleService localeService,
                                        ApiRequest apiRequest) {
        AppositionData appositionData = new AppositionData();
        appositionData.setComponentType(Address.COMPONENT_TYPE);
        Address address = new Address();
        address.setId(userAddress.getAddressId());
        address.setCompleteAddress(userAddress.getCompleteAddress());
        address.setAddress(userAddress.getDetailAddress());
        address.setMobile(userAddress.getUserPhone());
        address.setName(userAddress.getUserName());
        address.setUserId(userAddress.getUserId());
        address.setAreaId(userAddress.getAreaId());
        address.setCity(userAddress.getCity());
        address.setProvince(userAddress.getProvince());
        address.setArea(userAddress.getArea());
        List<Button> buttons = new ArrayList<>(2);
        buttons.add(Button.createModifiyAddress(UUIDUtil.getUuid(),
                JsonUtil.objectToJavaObject(userAddress, Map.class), apiRequest.getLocale(),
                localeService.getLanguageValue(apiRequest.getLocale(), "编辑")));
        buttons.add(Button.createDeleteAddress(UUIDUtil.getUuid(),
                JsonUtil.objectToJavaObject(userAddress, Map.class),
                localeService.getLanguageValue(apiRequest.getLocale(), "删除"), apiRequest.getPageId()));
        address.setEditButtons(buttons);

        appositionData.setData(address);
        return appositionData;
    }
}
