package com.digiwin.mobile.mobileuibot.core.component.attendance;

import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * 打卡位置组件
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GeoLocation extends BaseInputMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "GEO_LOCATION";

    /**
     * 1: 文本类型(默认)
     * 2: 图标类型
     * 图标类型时app默认给icon,不可配置
     */
    private Integer titleType = TitleTypeEnum.TEXT_TYPE.getValue() ;

    /**
     * 描述
     */
    private String title ;

    /**
     * 经纬度展示，默认false
     */
    private Boolean showLatAndLon = false;

    /**
     * 位置展示，默认false
     */
    private Boolean showLocationMap = false;

    /**
     * 地址信息，用于提交
     */
    private String locationInfo;


    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        //位置组件不能将数据源中的数据回填过来，所以只处理hooks就可以
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
    }


    @Override
    public String returnComponentType() {
        return GeoLocation.COMPONENT_TYPE;
    }
}
