package com.digiwin.mobile.mobileuibot.core.component.attendance;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Optional;

@Component("geoLocationParamAnalyzer")
public class GeoLocationParamAnalyzer implements ComponentParamAnalyzer<GeoLocation, String> {

    Logger logger = LoggerFactory.getLogger(GeoLocationParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return GeoLocation.COMPONENT_TYPE;
    }

    @Override
    public Class<GeoLocation> getSubmitParamType() {
        return GeoLocation.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof GeoLocation)) {
            logger.debug("submitParam is not instanceof GeoLocation component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        GeoLocation geoLocation = (GeoLocation) submitParam;
        return Optional.ofNullable(geoLocation.getLocationInfo()).orElse("");
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {

    }
}
