package com.digiwin.mobile.mobileuibot.core.component.attendance;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Optional;

@Component("wifiParamAnalyzer")
public class WifiParamAnalyzer implements ComponentParamAnalyzer<Wifi, String> {

    Logger logger = LoggerFactory.getLogger(WifiParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return Wifi.COMPONENT_TYPE;
    }

    @Override
    public Class<Wifi> getSubmitParamType() {
        return Wifi.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof Wifi)) {
            logger.debug("submitParam is not instanceof Wifi component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        Wifi wifi = (Wifi) submitParam;
        return Optional.ofNullable(wifi.getMacInfo()).orElse("");
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {

    }

}
