package com.digiwin.mobile.mobileuibot.core.component.avatar;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：头像组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Avatar.java
 * @Author: wangjwc
 * @Date: created at 2025/1/24 10:03
 */
@Data
public class Avatar extends BaseMobileComponent {
    private static final long serialVersionUID = -7274118639767080451L;
    public static final String COMPONENT_TYPE = "AVATAR";
    /**
     * 设计态--头像图片路径
     */
    private String image;
    private String imagePath;
    /**
     * 设计态--eocId
     */
    private String eocIdSchema;
    private String eocIdPath;

    /**
     * 运行态--头像名称
     */
    private String name;
    /**
     * 运行态--头像图片URL
     */
    private String imageUrl;
    /**
     * 默认0，样式，0=头像，1=头像+名称
     */
    private Integer styleType = AvatarTypeEnum.AVATAR.getValue();

    private Action action;

    @Override
    public String returnComponentType() {
        return Avatar.COMPONENT_TYPE;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.name = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema))
                .map(Object::toString)
                .orElse(null);
        this.imageUrl = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, this.imagePath, this.image))
                .map(Object::toString)
                .orElse(null);
        String eocId = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, this.eocIdPath, this.eocIdSchema))
                .map(Object::toString)
                .orElse(null);
        if (StringUtils.hasLength(eocId)) {
            Action<Map<String, Object>> action = new Action<>();
            action.setDataId(eocId);
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_EOCID.getValue());
            this.action = action;
        }

        // clear
        this.image = null;
        this.imagePath = null;
        this.eocIdSchema = null;
        this.eocIdPath = null;
    }
}
