package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroupAlignEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * 依规则数据，由前端自动填充数值的组件
 *
 * @author Wuyang
 * @date 2022/12/30 0013 17:18
 */
@Data
public class AutoFill extends BaseInputMobileComponent {
    private static final long serialVersionUID = 4409556361187206414L;
    public static final String COMPONENT_TYPE = "AUTO_FILL";

    @Override
    public String returnComponentType() {
        return AutoFill.COMPONENT_TYPE;
    }

    private List<AutoFillData> data;

    private String title;
    /**
     * 0-居中对齐，1-左对齐，2-右对齐
     *
     * @see ButtonGroupAlignEnum
     */
    private Integer align = ButtonGroupAlignEnum.RIGHT.getValue();

    public AutoFill() {
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        List<AutoFillData> fillData = this.getData();
        if (!CollectionUtils.isEmpty(fillData)) {
            fillData.forEach(autoFillData -> autoFillData.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData));
        }
    }
}
