package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.TargetDatetime;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizReport;
import lombok.Data;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * 依规则数据，由前端自动填充数值的组件
 *
 * @author xujinc
 * @date 2023/11/29 17:18
 */
@Data
public class AutoFillData extends BaseMobileComponent {
    private static final long serialVersionUID = 4139155369185206418L;
    public static final String COMPONENT_TYPE = "AUTO_FILL_DATA";

    private String name;

    private String nameColor;

    private String nameSize;

    private Action action;

    private RelationRule relationRule;

    // 设计器新增属性----------------------------
    private String id;
    /**
     * 1:开启页面，2：开启弹窗，3：执行JS脚本
     *
     * @see AutoFillTypeEnum
     */
    private Integer type;
    /**
     * 不同type下，对应不同值
     */
    private String content;

    /**
     * 手动任务一键报工
     * 1.实际开始日没有值时，回填计划开始日，如果有值，则不变。日期格式为：yyyy.MM.dd
     * 2.实际完成日期重置为系统日期（即当天）。日期格式为：yyyy.MM.dd
     * 3.完成率重置为1
     *
     * @param pcData
     * @param pcDataLayout
     * @param name
     * @return
     */
    public static AutoFillData create(String name, UiBotLayout pcDataLayout, Map<String, Object> pcData, Map<String, Object> variableListSimpleMap) {
        AutoFillData autoFillData = new AutoFillData();
        autoFillData.setName(name);
        autoFillData.setNameColor("5037DB");
        autoFillData.setNameSize("28");
        RelationRule relationRule = new RelationRule();
        List<CommonRule> ruleList = new ArrayList<>();

        String rawActualStartDate = String.valueOf(pcData.get("actual_start_date")).trim();
        String rawPlanStartDate = String.valueOf(pcData.get("plan_start_date")).trim();
        if (!StringUtils.hasLength(rawActualStartDate)) {
            CommonRule actualStartDateRule = new CommonRule();
            actualStartDateRule.setCondition(CommonRuleCondition.CONDITION_EMPTY_RESET.getType());
            String rawTargetText = rawActualStartDate;
            if (!StringUtils.hasLength(rawActualStartDate)) {
                rawTargetText = rawPlanStartDate;
            }
            boolean isAfterNowDate = DateTimeUtil.isAfterNowDate(rawTargetText);
            if (isAfterNowDate) {
                rawTargetText = DateTimeUtil.getTodayUseDefaultPattern();
            }
            actualStartDateRule.setTargetText(DateTimeUtil.getDateTextInMobileShowDefaultPattern(rawTargetText));
            actualStartDateRule.setTargetSchema("actual_start_date");
            ruleList.add(actualStartDateRule);
        }
        if ("task_info".equalsIgnoreCase(pcDataLayout.getSchema())) {
            //实际开始日期
            CommonRule actualStartDateRule = new CommonRule();
            actualStartDateRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
            actualStartDateRule.setTargetText(DateTimeUtil.getTodayDateTextInMobileShowDefaultPattern());
            actualStartDateRule.setTargetSchema("actual_start_date");
            if ((Boolean) pcData.get("is_attachment")) {
                CommonRule rule = new CommonRule();
                rule.setCondition(1);
                rule.setTargetRequired(true);
                rule.setTargetSchema("delivery");
                ruleList.add(rule);
            }
            ruleList.add(actualStartDateRule);
        }

        //实际开始日期有变化则需要置空实际结束日期
        CommonRule commonRule1 = new CommonRule();
        commonRule1.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        commonRule1.setTargetSchema("actual_finish_date");
        commonRule1.setTargetText("");
        commonRule1.setTargetHidden(null);
        commonRule1.setTargetEnable(true);
        //防呆，选择的时间不能小于开始的时间
        List<TargetDatetime> targetDatetimes = new ArrayList<>();
        TargetDatetime targetDatetime1 = new TargetDatetime();
        targetDatetime1.setDatetimeType(1);
        targetDatetime1.setLinkageSchema("actual_start_date");
        targetDatetimes.add(targetDatetime1);
        commonRule1.setTargetDatetime(targetDatetimes);
        ruleList.add(commonRule1);

        //实际结束日期
        CommonRule actualFinshDateRule = new CommonRule();
        actualFinshDateRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        actualFinshDateRule.setTargetText(DateTimeUtil.getTodayDateTextInMobileShowDefaultPattern());
        actualFinshDateRule.setTargetSchema("actual_finish_date");
        ruleList.add(actualFinshDateRule);
        //完成率
        CommonRule completeRateRule = new CommonRule();
        completeRateRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        completeRateRule.setTargetText("100");
        completeRateRule.setTargetSchema("complete_rate");
        ruleList.add(completeRateRule);

        // 交付设计器允许事后报工
        if (!CollectionUtils.isEmpty(variableListSimpleMap)) {
            Boolean isAllowReportAfter = MapUtils.getBoolean(variableListSimpleMap, "isAllowReportAfter");
            if (BooleanUtils.isTrue(isAllowReportAfter)) {
                CommonRule reportDateCommonRule = new CommonRule();
                reportDateCommonRule.setTargetSchema("report_date");
                reportDateCommonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                TargetDatetime reportDateTargetDatetime = new TargetDatetime();
                reportDateTargetDatetime.setLinkageSchema("actual_start_date");
                reportDateTargetDatetime.setDatetimeType(1);
                reportDateCommonRule.setTargetDatetime(Collections.singletonList(reportDateTargetDatetime));
                reportDateCommonRule.setTargetEnable(true);
                ruleList.add(reportDateCommonRule);
            } else {
                CommonRule actualFinishDateCommonRule = new CommonRule();
                actualFinishDateCommonRule.setTargetSchema("actual_finish_date");
                actualFinishDateCommonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                TargetDatetime actualFinishDatTargetDatetime = new TargetDatetime();
                actualFinishDatTargetDatetime.setLinkageSchema("actual_start_date");
                actualFinishDatTargetDatetime.setDatetimeType(1);
                actualFinishDateCommonRule.setTargetDatetime(Collections.singletonList(actualFinishDatTargetDatetime));
                actualFinishDateCommonRule.setTargetEnable(true);
                ruleList.add(actualFinishDateCommonRule);
            }
        }

        relationRule.setRuleList(ruleList);
        autoFillData.setRelationRule(relationRule);
        return autoFillData;
    }

    public static AutoFillData create(ApiRequest apiRequest, TaskDetailBizReport taskDetailBizReport, LocaleService localeService, Boolean isworkHourZero) {
        String locale = apiRequest.getLocale();

        AutoFillData autoFillData = new AutoFillData();
        autoFillData.setName(localeService.getLanguageValue(locale, "代为报工"));
        autoFillData.setNameColor("5037DB");
        autoFillData.setNameSize("28");

        Action replaceReportAction = new Action();
        replaceReportAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_REPLACE_REPORT_TASK_EXECUTOR_DETAIL.toString());
        replaceReportAction.setJumpPageTitle(localeService.getLanguageValue(locale, "批量选择执行人"));
        replaceReportAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());

        Map<String, Object> workHoursRawData = new HashMap<>();
        workHoursRawData.put("isworkHourZero", isworkHourZero);
        workHoursRawData.putAll(apiRequest.getRawData());

        MobileComponent workHoursMobileComponent = taskDetailBizReport.get("work_hours");
        if (!Objects.isNull(workHoursMobileComponent)) {
            InputNumeric workHours = JsonUtil.objectToJavaObject(workHoursMobileComponent, InputNumeric.class);
            workHours.setType(InputNumericTypeEnum.DECIMAL_ALLOW_NEGATIVE.getValue());
            workHours.setMaxLength(99999999);

            List<ValidateRule> validateRuleList = new ArrayList<>(2);
            ValidateRule validateWorkHoursPrecisionRule = new ValidateRule();
            validateWorkHoursPrecisionRule.setSchema("work_hours");
            validateWorkHoursPrecisionRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
            validateWorkHoursPrecisionRule.setType(ValidateRuleTypeEnum.PATTERN.getType());
            validateWorkHoursPrecisionRule.setParameter("^(-?)*(?=.*0|[1-9])\\d*(?:\\.\\d{1,2})?\\s*$");
            validateWorkHoursPrecisionRule.setErrorMessage(localeService.getLanguageValue(locale, "最多两位小数"));
            validateRuleList.add(validateWorkHoursPrecisionRule);
            //交付设计器.工时不可为0
            if (isworkHourZero) {
                ValidateRule validateRule1 = new ValidateRule();
                validateRule1.setSchema("work_hours");
                validateRule1.setScope(ValidateRuleScopeEnum.EDIT.getScope());
                validateRule1.setType(ValidateRuleTypeEnum.APPOINT.getType());
                validateRule1.setOperatorType(2);
                validateRule1.setParameter("0");
                validateRule1.setErrorMessage(localeService.getLanguageValue(locale, "工时不能等于0"));
                validateRule1.setOrder(1);
                validateRule1.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                validateRuleList.add(validateRule1);
            }

            MobileComponent totalwWorkHoursMobileComponent = taskDetailBizReport.get("total_work_hours");
            if (!Objects.isNull(totalwWorkHoursMobileComponent)) {
                InputNumeric totalwWorkHours = JsonUtil.objectToJavaObject(totalwWorkHoursMobileComponent, InputNumeric.class);

                ValidateRule validateSumWorkHoursRule = new ValidateRule();
                validateSumWorkHoursRule.setSchema("work_hours");
                validateSumWorkHoursRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
                validateSumWorkHoursRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
                validateSumWorkHoursRule.setParameter(new BigDecimal(totalwWorkHours.getText()).negate().toString());
                validateSumWorkHoursRule.setOperatorType(6);
                validateSumWorkHoursRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                validateSumWorkHoursRule.setErrorMessage(localeService.getLanguageValue(locale, "耗用总工时与工时累计不可小于0！"));
                validateRuleList.add(validateSumWorkHoursRule);
            }
            workHours.setValidateRuleList(validateRuleList);

            workHoursRawData.put("work_hours", workHours);
            taskDetailBizReport.put("work_hours", workHours);
        }
        replaceReportAction.setRawData(workHoursRawData);
        autoFillData.setAction(replaceReportAction);
        return autoFillData;
    }

    @Override
    public String returnComponentType() {
        return AutoFillData.COMPONENT_TYPE;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.nameColor = "6A4CFF";
        this.nameSize = "28";
        if (AutoFillTypeEnum.OPEN_PAGE.getValue().equals(this.type)) {
            Action<Map<String, Object>> action = new Action<>();
            action.setJumpPageId(this.content);
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            this.action = action;
        } else if (AutoFillTypeEnum.OPEN_WINDOW.getValue().equals(this.type)) {
            Action<Map<String, Object>> action = new Action<>();
            action.setJumpPageId(this.content);
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            this.action = action;
        } else if (AutoFillTypeEnum.EXECUTE_JS.getValue().equals(this.type)) {
            this.action = null;
        } else {
            this.action = null;
        }

        if (this.action != null) {
            Map<String, Object> rawData = new HashMap<>();
            rawData.put("allRawMap", mobilePageRawData.getAllRawMap());
            rawData.put("rawMap", mobilePageRawData.getRawMap());
            rawData.put("rawDataType", mobilePageRawData.getRawDataType());
            rawData.put("baseEntryExtendedFields", mobilePageRawData.getExtendedFields());
            rawData.put("sourceCategory", mobilePageRawData.getSourceCategory());
            rawData.put("dataKeys", mobilePageRawData.getDataKeys());
            rawData.put("componentId", mobilePageRawData.getComponentId());
            // rawdata中存入代理token，此值在拦截器中处理
            rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
            rawData.put("data", data);
            rawData.put("executeContext", executeContext);
            this.action.setRawData(rawData);
        }
    }
}
