package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 常用条件组件
 *
 * @author wuyang
 */
@Data
public class CommonConditions extends BaseMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "COMMON_CONDITIONS";
    private static final long serialVersionUID = 933499371391832630L;
    /**
     * 标题
     */
    private String title;
    /**
     * 条件对象
     */
    private List<Button> conditions = new ArrayList<>();
    /**
     * 用于全部删除时，所需要的后端参数
     */
    private Map<String, Object> rawData = new HashMap<>();

    @Override

    public String returnComponentType() {
        return CommonConditions.COMPONENT_TYPE;
    }
}
