package com.digiwin.mobile.mobileuibot.core.component.basic;

import java.io.Serializable;

/**
 * <p>功能描述：多字段对比展示组件。newValue会优先并放大展示，oldValue在后面展示</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ComparisonField
 * @Author: Zaregoto
 * @Date: 2021/8/4 17:57
 */
public class ComparisonField extends Field {
    private static final long serialVersionUID = -4360106513370409322L;

    /**
     * 标识是否用于比较
     */
    private Boolean forCompare = false;
    /**
     * 存储比较数据
     */
    private ComparedValue comparedValue;

    protected ComparisonField() {
    }

    protected ComparisonField(String label, String type, String value, Boolean forCompare,
                              String oldValue, String newValue) {
        super(label, type, value);
        this.forCompare = forCompare;
        this.comparedValue = new ComparedValue(oldValue, newValue);
    }

    protected ComparisonField(String label, String type, String value, Boolean forCompare,
                              String oldValuePrefix, String oldValue, String newValuePrefix, String newValue) {
        super(label, type, value);
        this.forCompare = forCompare;
        this.comparedValue = new ComparedValue(oldValuePrefix, oldValue, newValuePrefix, newValue);
    }

    public static ComparisonField create(String label, String type, String value, Boolean forCompare,
                                         String oldValue, String newValue) {
        return new ComparisonField(label, type, value, forCompare, oldValue, newValue);
    }

    public static ComparisonField create(String label, String type, String value, Boolean forCompare,
                                         String oldValuePrefix, String oldValue, String newValuePrefix, String newValue) {
        return new ComparisonField(label, type, value, forCompare, oldValuePrefix, oldValue, newValuePrefix, newValue);
    }

    public Boolean getForCompare() {
        return forCompare;
    }

    public void setForCompare(Boolean forCompare) {
        this.forCompare = forCompare;
    }

    public ComparedValue getComparedValue() {
        return comparedValue;
    }

    public void setComparedValue(ComparedValue comparedValue) {
        this.comparedValue = comparedValue;
    }

    public class ComparedValue implements Serializable {
        private static final long serialVersionUID = 7522916919803863950L;

        private String oldValuePrefix;
        private String oldValue;
        private String newValuePrefix;
        private String newValue;


        public ComparedValue() {
        }

        public ComparedValue(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public ComparedValue(String oldValuePrefix, String oldValue, String newValuePrefix,
                             String newValue) {
            this.oldValuePrefix = oldValuePrefix;
            this.oldValue = oldValue;
            this.newValuePrefix = newValuePrefix;
            this.newValue = newValue;
        }

        public String getOldValuePrefix() {
            return oldValuePrefix;
        }

        public void setOldValuePrefix(String oldValuePrefix) {
            this.oldValuePrefix = oldValuePrefix;
        }

        public String getOldValue() {
            return oldValue;
        }

        public void setOldValue(String oldValue) {
            this.oldValue = oldValue;
        }

        public String getNewValuePrefix() {
            return newValuePrefix;
        }

        public void setNewValuePrefix(String newValuePrefix) {
            this.newValuePrefix = newValuePrefix;
        }

        public String getNewValue() {
            return newValue;
        }

        public void setNewValue(String newValue) {
            this.newValue = newValue;
        }
    }
}
