package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.Data;

/**
 * <p>功能描述：空状态组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Empty
 * @Author: Zaregoto
 * @Date: 2022/2/11 0:33
 */
@Data
public class Empty extends BaseMobileComponent {

    public static final String COMPONENT_TYPE = "EMPTY";
    private static final long serialVersionUID = -2174743971099781193L;

    @Override
    public String returnComponentType() {
        return Empty.COMPONENT_TYPE;
    }

    private Boolean showImage = true;
    private String text;
    /**
     * 字体颜色
     */
    private String textColor;

    private Integer imageWidth;
    private Integer imageHeight;
    private String image;
    /**
     * 空组件的高度
     */
    private Integer height = 500;

    /**
     * 间距
     */
    private Integer padding;

//    /**
//    *  是否有刷新当前页面 重试按钮
//    */
//    private Boolean isRefreshRetry = false;

    public Empty() {
    }

    /**
     * 创建一个空组件，默认展示图片
     *
     * @param text
     * @return
     */
    public static Empty create(String text) {
        Empty empty = new Empty();
        empty.setText(text);

        return empty;
    }

    /**
     * 创建一个空组件，支持设置图片是否展示和图片宽高
     *
     * @param text
     * @return
     */
    public static Empty create(String text, Boolean showImage, Integer imageWidth, Integer imageHeight) {
        Empty empty = new Empty();
        empty.setText(text);
        empty.setShowImage(showImage);
        empty.setImageHeight(imageHeight);
        empty.setImageWidth(imageWidth);

        return empty;
    }

    /**
     * 创建一个空组件，支持设置图片是否展示和图片宽高
     *
     * @param text
     * @return
     */
    public static Empty createByAbiReport(String text, Boolean showImage, Integer imageWidth, Integer imageHeight, String textColor) {
        Empty empty = new Empty();
        empty.setText(text);
        empty.setShowImage(showImage);
        empty.setImageHeight(imageHeight);
        empty.setImageWidth(imageWidth);
        empty.setTextColor(textColor);
        return empty;
    }

    /**
     * 创建一个空组件，支持设置图片是否展示
     *
     * @param text
     * @param showImage
     * @return
     */
    public static Empty create(String text, boolean showImage) {
        Empty empty = new Empty();
        empty.setText(text);
        empty.setShowImage(showImage);

        return empty;
    }

    /**
     * 创建一个空组件，支持设置图片是否展示，有大小和地址
     *
     * @param text
     * @param showImage
     * @return
     */
    public static Empty create(String text, boolean showImage, Integer imageWidth, Integer imageHeight, String image) {
        Empty empty = new Empty();
        empty.setText(text);
        empty.setShowImage(showImage);
        empty.setImageWidth(imageWidth);
        empty.setImageHeight(imageHeight);
        empty.setImage(image);

        return empty;
    }

    /**
     * 创建一个是否包含 刷新当前页面按钮的组件
     */
    public static Empty create(String text, boolean showImage, Integer imageWidth,
                               Integer imageHeight, String image, boolean isRefreshRetry) {
        Empty empty = new Empty();
        empty.setText(text);
        empty.setShowImage(showImage);
        empty.setImageWidth(imageWidth);
        empty.setImageHeight(imageHeight);
        empty.setImage(image);
//        empty.setIsRefreshRetry(isRefreshRetry);

        return empty;
    }

    public static Empty create(String text, boolean showImage, Integer padding, Integer height, Integer imageWidth, Integer imageHeight, String textColor, String image) {
        Empty empty = new Empty();
        empty.setText(text);
        empty.setShowImage(showImage);
        empty.setImageWidth(imageWidth);
        empty.setImageHeight(imageHeight);
        empty.setImage(image);
        empty.setHeight(height);
        empty.setTextColor(textColor);
        empty.setPadding(padding);
        return empty;
    }

    public Boolean getShowImage() {
        return showImage;
    }

    public void setShowImage(Boolean showImage) {
        this.showImage = showImage;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Integer getImageWidth() {
        return imageWidth;
    }

    public void setImageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
    }

    public Integer getImageHeight() {
        return imageHeight;
    }

    public void setImageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }
}
