package com.digiwin.mobile.mobileuibot.core.component.basic;

/**
 * <p>功能描述：字段label和value展示组件使用的对齐方式枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: FieldAlignmentTypeEnum
 * @Author: Zaregoto
 * @Date: 2022/3/1 11:04
 */
public enum FieldAlignmentTypeEnum {

    /**
     * 1-label左对齐value右对齐，上下间距为32px(只要有录入的拿这个)
     */
    LABEL_LEFT_VALUE_RIGHT(1),
    /**
     * 11-label左对齐value右对齐,上下间距为18px(只要纯展示的拿这个)
     */
    LABEL_LEFT_VALUE_RIGHT_WITH_18PX(11),


    /**
     * 2-label和value均居中对齐
     */
    LABEL_LEFT_VALUE_CENTER(2),


    /**
     * 3-label和value均左对齐,当超过长度,则...显示（左边距24px）,上下间距16px
     */
    LABEL_LEFT_VALUE_LEFT(3),
    /**
     * 3-label和value均左对齐,当超过长度,则...显示（左边距24px）,上下间距18px
     */
    LABEL_LEFT_VALUE_LEFT_WITH_18PX(31),

    /**
     * 4-label和value均左对齐,当超过长度,则换行显示
     */
    LABEL_LEFT_VALUE_LEFT_NEWLINE(4),

    ;

    private Integer value;

    FieldAlignmentTypeEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

}
