package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * @author zhangjj
 * @date 2021/11/24 0024 14:46
 */
@Component("fieldParamAnalyzer")
public class FieldParamAnalyzer implements ComponentParamAnalyzer<Field, String> {

    private static final Logger logger = LoggerFactory.getLogger(FieldParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return Field.COMPONENT_TYPE;
    }

    @Override
    public Class getSubmitParamType() {
        return Field.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof Field)) {
            logger.debug("submitParam is not instanceof Field component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        Field field = (Field) submitParam;
        return Optional.ofNullable(field.getText()).orElse("");
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {

    }
}
