package com.digiwin.mobile.mobileuibot.core.component.basic;

import java.util.Objects;

/**
 * <p>功能描述：Field组件value样式枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: FieldValueStyleTypeEnum
 * @Author: zaregoto
 * @Date: 2023/4/12 21:46
 */
public enum FieldValueStyleTypeEnum {
    /**
     * 1：黑色，普通型文本
     */
    VALUE_BLACK(1),

    /**
     * 2：灰色，弱化型文本
     */
    VALUE_GRAY(2),

    /**
     * 3：大标题样式
     */
    VALUE_BIG_TITLE(3),

    /**
     * 4：红色
     */
    VALUE_RED(4),

    ;;

    private final Integer value;

    FieldValueStyleTypeEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static FieldValueStyleTypeEnum getEnumByValue(Integer value) {
        for (FieldValueStyleTypeEnum testedEnum : FieldValueStyleTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
