package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class HiddenConfig implements Serializable {

    private static final long serialVersionUID = -5412435040608532922L;

    /**
     * 触发隐藏时，隐藏的提示语
     */
    private String hiddenExpandContent;
    /**
     * 触发隐藏时，收起的提示语
     */
    private String hiddenUnexpandContent;
    /**
     * 触发隐藏的类型 1.代表字段；2.代表条目
     *
     * @see HiddenConfigTypeEnum
     */
    private Integer hiddenType;
    /**
     * 触发隐藏的数量。通常隐藏会隐藏界面的行数，由引用当前类的组件决定。如CustomGroup、InputMultiText等
     */
    private Integer hiddenCount;
    /**
     * ZtbViewList组件使用，因为设计器拖拽列表组件时默认hiddenCount=4，为了不影响2024-I06迭代新增查看更多逻辑，故新增属性处理
     */
    private Integer hiddenCountV2;

    private Action action = new Action();

    public void setAction(String pageTitle, Integer openType) {
        Action action = new Action();
        action.setType(openType);
        action.setJumpPageTitle(pageTitle);
        this.action = action;
    }
}
