package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 标签控件
 *
 * @author zhangjj
 * @date 2021/6/23 0023 15:11
 */
@Data
@NoArgsConstructor
public class Label implements Serializable {
    private static final long serialVersionUID = -2659759227013979213L;
    /**
     * 标签展示文字
     */
    private String text;
    /**
     * 标签类型
     * 可选值参考{@link LabelTypeEnum LabelTypeEnum} 枚举类
     */
    private String type;

    private Action action;

    public Label(String text, String type, Action action) {
        this.text = text;
        this.type = type;
        this.action = action;
    }

    public Label(String text, String type) {
        this.text = text;
        this.type = type;
    }

    public static Label create(String text, String type) {
        return new Label(text, type);
    }

    public static Label buildReassignReport(String locale, List<DigiwinReassignReport> reassignReportList) {
        Label label = new Label();
        label.setText(String.format(
                LocaleUtil.getMobileTextByKey(locale, "由转派"),
                reassignReportList.get(0).getOldPerformerName()));
        label.setType(LabelTypeEnum.NORMAL.getType());
        label.setAction(Action.createReassignReportAction(locale,
                reassignReportList));
        return label;
    }

}
