package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;

import java.util.Map;

/**
 * 消息提醒组件
 *
 * @author wuyang
 * @date 20221206
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MessageBar extends BaseMobileComponent {

    public static final String COMPONENT_TYPE = "MESSAGE_BAR";
    private static final long serialVersionUID = -1464009233599357503L;

    /**
     * 类型
     *
     * @see MessageBarTypeEnum
     */
    private String messageType;

    /**
     * 预警icon图标
     */
    private Integer iconData;
    /**
     * 显示的行数
     */
    private Integer lineNum = 1;
    /**
     * 预警样式
     *
     * @see MessageBarStyleTypeEnum
     */
    private Integer styleType = MessageBarStyleTypeEnum.RED_WORD_PINK_BACKGROUDCOLOR.getType();
    /**
     * 预警内容
     */
    private String content;

    /**
     * 位置属性
     *
     * @see MessageBarPositionEnum
     */
    private Integer position = MessageBarPositionEnum.CURRENT.getValue();
    /**
     * 支持关闭
     * true：是，false：否
     */
    private Boolean closable = false;

    /**
     * 是否滚动
     */
    private Boolean scroll;

    /**
     * 是否启用展开功能，默认false --- 设计器新增属性
     * 如果=true,强制赋值styleType=3（展开显示） --- 因前端根据styleType=3判断是否展开
     */
    private Boolean useExpand = false;

    @Override

    public String returnComponentType() {
        return MessageBar.COMPONENT_TYPE;
    }

    /**
     * 默认的预计样式和显示行数
     *
     * @param iconData
     * @param content
     * @return
     */
    public static MessageBar create(Integer iconData, String content) {
        MessageBar messageBar = new MessageBar();
        messageBar.setContent(content);
        messageBar.setIconData(iconData);
        messageBar.setLineNum(1);
        messageBar.setStyleType(MessageBarStyleTypeEnum.RED_WORD_PINK_BACKGROUDCOLOR.getType());
        return messageBar;
    }

    /**
     * 默认的预计样式和显示行数
     *
     * @param content
     * @return
     */
    public static MessageBar create(String content) {
        MessageBar messageBar = new MessageBar();
        messageBar.setContent(content);
        messageBar.setLineNum(1);
        messageBar.setStyleType(MessageBarStyleTypeEnum.RED_WORD_PINK_BACKGROUDCOLOR.getType());
        return messageBar;
    }

    /**
     * 默认的预计样式和显示行数和图标
     *
     * @param content
     * @param styleType
     * @return
     */
    public static MessageBar create(String content, Integer styleType, Integer iconData) {
        MessageBar messageBar = new MessageBar();
        messageBar.setContent(content);
        messageBar.setLineNum(1);
        messageBar.setStyleType(styleType);
        messageBar.setIconData(iconData);
        return messageBar;
    }

    /**
     * 默认的预计样式和显示行数
     *
     * @param content
     * @param styleType
     * @return
     */
    public static MessageBar create(String content, Integer styleType) {
        MessageBar messageBar = new MessageBar();
        messageBar.setContent(content);
        messageBar.setLineNum(1);
        messageBar.setStyleType(styleType);
        return messageBar;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        Object o = UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
        if (ObjectUtils.isNotEmpty(o)) {
            this.content = String.valueOf(o);
        }

        if (MessageBarTypeEnum.NORMAL.name().equalsIgnoreCase(this.messageType)) {
            this.iconData = 58953;
            this.styleType = MessageBarStyleTypeEnum.BLACK_WORD_WHITE_BACKGROUDCOLOR.getType();
        }
        if (MessageBarTypeEnum.ERROR.name().equalsIgnoreCase(this.messageType)) {
            this.iconData = 58984;
            this.styleType = MessageBarStyleTypeEnum.RED_WORD_PINK_BACKGROUDCOLOR.getType();
        }
        if (MessageBarTypeEnum.FINISH.name().equalsIgnoreCase(this.messageType)) {
            this.iconData = 58951;
            this.styleType = MessageBarStyleTypeEnum.BLACK_WORD_GREEN_BACKGROUDCOLOR.getType();
        }
        if (MessageBarTypeEnum.WARNING.name().equalsIgnoreCase(this.messageType)) {
            this.iconData = 58953;
            this.styleType = MessageBarStyleTypeEnum.BLACK_WORD_YELLOW_BACKGROUDCOLOR.getType();
        }
        if (BooleanUtils.isTrue(this.useExpand)){
            // 如果=true,强制赋值styleType=3（展开显示） --- 因前端根据styleType=3判断是否展开
            this.styleType = MessageBarStyleTypeEnum.BLACK_WORD_GREEN_BACKGROUDCOLOR.getType();
        }
    }

}
