package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.core.component.*;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 收起展开组件
 *
 * @author wuyang
 */
@Data
public class Retractable extends BaseMobileComponent implements Serializable {

    private static final long serialVersionUID = -7485078164778545657L;
    public static final String COMPONENT_TYPE = "RETRACYABLE";

    /**
     * 标题
     */
    private String title;
    /**
     * 是否展开
     */
    private Boolean isExpand = false;
    /**
     * 样式 默認1(旧样式 白底)、2(新样式 无底色 间距合适)
     */
    private Integer style;

    /**
     * 布局模式 默認0(居中)、1(靠左)、2(靠右)
     */
    private Integer alignmentType;

    /**
     * 标题后面图标颜色
     * 1为红色  2为紫色  3为绿色
     */
    private Integer iconStatus;

    /**
     * 多个折叠组件嵌套时  外层的折叠层数
     */
    private Integer level = 0;

    /**
     * 描述
     */
    private String desc;

    /**
     * 选择方式，NO_CHOICE：不支持选择----默认
     */
    private String choice = MultiFunctionListChoiceEnum.NO_CHOICE.name();

    private Map<String, Object> rawData;

    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> content = new ArrayList<>();

    private CustomTitle customTitle;

    @Data
    public static class CustomTitle {
        private String title;

        private String titlePath;

        private TitleSetting titleSetting;

        private Boolean isCustom = false;

        @Data
        public static class TitleSetting {
            private String type;

            private Setting setting;
        }

        @Data
        public static class Setting {
            private List<Option> options;
        }

        @Data
        public static class Option {
            private String id;

            //选项内容
            private String text;

            private String value;
        }
    }

    @Override
    public String returnComponentType() {
        return Retractable.COMPONENT_TYPE;
    }

    public static Retractable buildRetractable(ApiRequest apiRequest, LocaleService localeService, List<WoOpReportInfo> woOpReportInfoList) {
        Retractable retractable = new Retractable();
        retractable.setTitle(woOpReportInfoList.get(0).getTeamName());
        retractable.setStyle(2);
        retractable.setAlignmentType(2);
        retractable.setIsExpand(true);
        retractable.setContent(Collections.singletonList(new BaseMobileComponentWrapper<>(ZtbViewList.buildZtbViewList(apiRequest, localeService, woOpReportInfoList), ZtbViewList.COMPONENT_TYPE)));
        return retractable;
    }

    public static List<Retractable> buildRetractable(ApiRequest apiRequest, LocaleService localeService,
                                                     Map<String, Map<String, List<WoOpReportInfo>>> woOpReportInfoList, String taskNameField, String bgColor) {
        return woOpReportInfoList.entrySet().stream().map(woOpReportInfoByWoNo -> {
            Retractable retractable = new Retractable();
            String title = woOpReportInfoByWoNo.getKey();

            // 项目号展示project_no+project_name
            if ("2".equals(taskNameField)) {
                title = Optional.ofNullable(woOpReportInfoByWoNo.getValue())
                        .map(e -> e.values())
                        .map(e -> e.iterator().next())
                        .map(e -> e.get(0))
                        .map(e -> e.getProjectNo() + " " + e.getProjectName()).orElse("");
            }
            retractable.setTitle(title);
            retractable.setStyle(2);
            retractable.setAlignmentType(2);
            retractable.setIsExpand(true);

            List<BaseMobileComponentWrapper<BaseMobileComponent>> customTabContentContainerByOpNoList = woOpReportInfoByWoNo.getValue().entrySet().stream()
                    .map(woOpReportInfoByOpNo -> {
                        Retractable retractableByOpNo = new Retractable();
                        retractableByOpNo.setTitle(Optional.ofNullable(woOpReportInfoByOpNo.getValue())
                                .map(e -> e.get(0)).map(WoOpReportInfo::getOpName).orElse(""));
                        retractableByOpNo.setStyle(2);
                        retractableByOpNo.setAlignmentType(2);
                        retractableByOpNo.setLevel(1);
                        retractableByOpNo.setIsExpand(true);

                        retractableByOpNo.setContent(Collections.singletonList(
                                new BaseMobileComponentWrapper<>(
                                        ZtbViewList.buildWoOpReportInfoSupportZtbViewList(apiRequest, localeService, woOpReportInfoByOpNo.getValue(), bgColor),
                                        ZtbViewList.COMPONENT_TYPE)));

                        return new BaseMobileComponentWrapper<BaseMobileComponent>(retractableByOpNo, Retractable.COMPONENT_TYPE);
                    }).collect(Collectors.toList());

            retractable.setContent(customTabContentContainerByOpNoList);
            return retractable;
        }).collect(Collectors.toList());
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.rawData = data;

        if (Objects.nonNull(this.customTitle)) {
            //自定义的标题的处理
            if (BooleanUtils.isTrue(this.customTitle.getIsCustom())) {
                this.title = this.customTitle.getTitle();
            } else {
                //标题展示枚举值或字段值处理
                String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, this.customTitle.getTitlePath(), this.customTitle.getTitle()))
                        .map(Object::toString)
                        .orElse(null);
                List<CustomTitle.Option> options = Optional.ofNullable(this.customTitle.getTitleSetting())
                        .map(CustomTitle.TitleSetting::getSetting)
                        .map(CustomTitle.Setting::getOptions)
                        .orElse(null);
                //是否是枚举值映射
                if (!CollectionUtils.isEmpty(options)) {
                    this.title = options.stream()
                            .filter(e -> e.getId().equals(value))
                            .findFirst()
                            .map(e -> e.getText())
                            .orElse(value);
                } else {
                    this.title = value;
                }
            }
        }
        if (BooleanUtils.isNotTrue(cmptContext.getAddAllSelectButton())) {
            if (MultiFunctionListChoiceEnum.MULTIPLE_CHOICE.name().equals(this.choice)) {
                // 多选下，自动渲染全选按钮
                cmptContext.setAddAllSelectButton(true);
            }
        }
        SpringContextHolder.getBean(UiBotDesignerRenderService.class).buildCmptDsl(cmptContext, executeContext, this.getContent(), data, mobilePageRawData);
    }
}
