package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import lombok.Data;
import lombok.Getter;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Tag
 * @Author: Zaregoto
 * @Date: 2021/6/14 15:43
 */
@Data
public class Tag extends BaseMobileComponent {
    private static final long serialVersionUID = 5784030906654402178L;
    public static final String COMPONENT_TYPE = "TAG";

    private String text;
    /**
     * 标签样式类型
     *
     * @see TagType
     */
    private Integer type;

    /**
     * 点击事件（目前只在TITLE_BODY组件中使用） by zhangjj 2022.9.19
     */
    private Action action;

    /**
     * label相对于标题的位置，默认为外层同名参数，有值时覆盖外层同名参数（目前只在TITLE_BODY组件中使用） by zhangjj 2022.9.19
     *
     * @See com.digiwin.mobile.mobileuibot.core.component.title.TitleLabelPositionEnum
     */
    private Integer labelPosition;

    // 以下属性仅在type=0(自定义类型)时生效
    // 背景颜色
    private String bgColor = "F0F3FF";
    // 边框颜色
    private String borderColor = "4670F7";
    // 文字颜色
    private String textColor = "4670F7";

    public Tag() {
    }

    public Tag(String text, Integer type) {
        this.text = text;
        this.type = type;
    }

    public Tag(String text, Integer type, Action action) {
        this.text = text;
        this.type = type;
        this.action = action;
    }

    public Tag(String text, Integer type, Action action, Integer labelPosition) {
        this.text = text;
        this.type = type;
        this.action = action;
        this.labelPosition = labelPosition;
    }

    /**
     * 创建警告类型的标签
     *
     * @param text
     * @return
     */
    public static Tag createWarningTag(String text) {
        return new Tag(text, TagType.WARNING.getValue());
    }

    /**
     * 创建提示类型的标签
     *
     * @param text
     * @return
     */
    public static Tag createPromptTag(String text) {
        return new Tag(text, TagType.PROMPT.getValue());
    }

    /**
     * 创建带按钮的提示类型的标签
     *
     * @param text
     * @return
     */
    public static Tag createPromptTag(String text, Action action) {
        return new Tag(text, TagType.PROMPT.getValue(), action);
    }

    /**
     * 创建签核状态类型的标签
     *
     * @param text
     * @return
     */
    public static Tag createApprovalStateTag(String text) {
        return new Tag(text, TagType.APPROVAL_STATE.getValue());

    }

    /**
     * 创建圆角浅蓝色底色、深蓝色字体的标签且在标题右边
     *
     * @param text
     * @param action
     * @param labelPosition
     * @return
     */
    public static Tag createBabyBuleBgdBuleTextOnRightTag(String text, Action action, Integer labelPosition) {
        return new Tag(text, TagType.BABY_BULE_BGD_BULE_TEXT.getValue(), action, labelPosition);

    }

    /**
     * 创建“新”提示（绿底白字）类型的标签
     *
     * @param text
     * @return
     */
    public static Tag createNewHintStateTag(String text) {
        return new Tag(text, TagType.NEW_HINT.getValue());
    }

    /**
     * 创建“蓝框白底蓝字”类型的标签
     *
     * @param text
     * @return
     */
    public static Tag createBlueBgdWriteTextStateTag(String text) {
        return new Tag(text, TagType.BLUE_BGD_WRITE_TEXT.getValue());
    }

    /**
     * 创建“蓝框白底蓝字”类型的标签
     *
     * @param text
     * @return
     */
    public static Tag createBlueBgdWriteTextStateTag(String text, Action action) {
        return new Tag(text, TagType.BLUE_BGD_WRITE_TEXT.getValue(), action);
    }

    /**
     * 创建“无边框”类型的标签
     *
     * @param text
     * @return
     */
    public static Tag createOnlyTextStateTag(String text, Action action) {
        return new Tag(text, TagType.ONLY_TEXT.getValue(), action);
    }

    /**
     * 创建"白框蓝底白字"类型的标签
     *
     * @param text
     * @param action
     * @return
     */
    public static Tag createWriteBgdBlueTextTag(String text, Action action) {
        return new Tag(text, TagType.WRITE_BGD_BULE_TEXT.value, action);
    }

    /**
     * 创建低风险-紫色(纯文本)标签
     *
     * @param text
     * @return
     */
    public static Tag createBlueTextTag(String text) {
        return new Tag(text, TagType.BLUE_TEXT.getValue());
    }

    /**
     * 创建低风险-紫色(纯文本)标签
     *
     * @param text
     * @return
     */
    public static Tag createNoRiskTag(String text) {
        return new Tag(text, TagType.LOW_RISK.getValue());
    }

    /**
     * 创建中风险-黄色(纯文本)标签
     *
     * @param text
     * @return
     */
    public static Tag createMediumRiskTag(String text) {
        return new Tag(text, TagType.MEDIUM_RISK.getValue());
    }

    /**
     * 创建高风险-红色(纯文本)标签
     *
     * @param text
     * @return
     */
    public static Tag createHighRiskTag(String text) {
        return new Tag(text, TagType.HIGH_RISK.getValue());
    }

    @Override
    public String returnComponentType() {
        return Tag.COMPONENT_TYPE;
    }

    @Getter
    public enum TagType {
        /**
         * 自定义类型--设计器配置对应样式
         */
        CUSTOM(0),
        /**
         * 警告类型
         */
        WARNING(1),

        /**
         * 提示类型
         */
        PROMPT(2),

        /**
         * 签核状态类型
         */
        APPROVAL_STATE(11),
        /**
         * 圆角浅蓝色底色、深蓝色字体（签核进度使用）
         */
        BABY_BULE_BGD_BULE_TEXT(12),
        /**
         * “新”提示（绿底白字）
         */
        NEW_HINT(3),

        /**
         * 蓝框白底蓝字
         */
        BLUE_BGD_WRITE_TEXT(4),
        /**
         * 白框蓝底白字
         */
        WRITE_BGD_BULE_TEXT(5),
        /**
         * 无边框类型(纯文本)
         */
        ONLY_TEXT(6),

        /**
         * 蓝边蓝子
         */
        BLUE_TEXT(7),

        /**
         * 低风险-紫色(纯文本)
         */
        LOW_RISK(71),

        /**
         * 中风险-黄色(纯文本)
         */
        MEDIUM_RISK(72),

        /**
         * 高风险-红色(纯文本)
         */
        HIGH_RISK(73);

        private final Integer value;

        TagType(Integer value) {
            this.value = value;
        }
    }
}
