package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailFixedNameEnum;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.util.Map;
import java.util.Optional;

/**
 * @author zhangjj
 * @date 2021/12/20 0020 17:31
 */
@Data
public class TextMulti extends BaseMobileComponent {
    public static final String COMPONENT_TYPE = "TEXT_MULTI";
    private static final long serialVersionUID = -3597902465281112733L;

    private String title;
    private String value;
    /**
     * 标题的样式类型
     * 1-标题弱化，呈灰色， 2-标题正常，呈黑色， 3-标题黑色加粗，字号30px
     */
    private Integer titleStyleType;
    /**
     * 0: 有上下间距且有title； 1: 没有上下间距且title失效
     */
    private Integer styleType = 0;
    /**
     * 是否启用收起展开功能
     */
    private Boolean useExpand = true;
    private HiddenConfig hiddenConfig = new HiddenConfig();

    public TextMulti() {
    }

    public TextMulti(String title, String value) {
        this.title = title;
        this.value = value;
    }

    public static TextMulti create(UiBotTableColumn column, String value, String locale) {
        TextMulti textMulti = new TextMulti(column.getHeaderName(), value);
        buildHiddenConfig(textMulti, locale);
        return textMulti;
    }

    public static TextMulti create(String title, String value, String locale) {
        TextMulti textMulti = new TextMulti(title, value);
        buildHiddenConfig(textMulti, locale);
        return textMulti;
    }

    public static TextMulti create(String title, String value, String locale, Integer styleType) {
        TextMulti textMulti = new TextMulti(title, value);
        textMulti.setStyleType(styleType);
        buildHiddenConfig(textMulti, locale);
        return textMulti;
    }

    public static TextMulti create(String locale, String iamUserToken, Map<String, Object> detailInfo) {
        TextMulti textMulti = new TextMulti();
        textMulti.setTitle(
                LocaleUtil.getMobileTextByKey(locale, SearchItemDetailFixedNameEnum.QUESTION_DESCRIPTION.getValue())
        );
        textMulti.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_THREE.getValue());
        textMulti.setValue(String.valueOf(detailInfo.get("knowledge_desc")));
        buildHiddenConfig(textMulti, locale);
        return textMulti;
    }

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public static HiddenConfig buildHiddenConfig(TextMulti textMulti, String locale) {
        HiddenConfig hiddenConfig = textMulti.getHiddenConfig();
        hiddenConfig.setHiddenCount(4);
        hiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey(locale, "收起"));
        hiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey(locale, "查看更多"));
        return hiddenConfig;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema))
                .map(Object::toString)
                .orElse(null);
        if (StringUtils.hasLength(value)) {
            this.value = value;
        } else {
            this.value = "-";
        }
    }
}
