package com.digiwin.mobile.mobileuibot.core.component.breadcrumb;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class BreadCrumb extends BaseMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "BREAD_CRUMB";
    private static final long serialVersionUID = -4892583412444715368L;


    /**
     * 面包屑的数据
     */
    private List<BreadCrumbNode> data = new ArrayList<>(3);


    @Override

    public String returnComponentType() {
        return BreadCrumb.COMPONENT_TYPE;
    }

    public Map<String, Object> searchCurrentNewParameter(BreadCrumb breadCrumb, int crumbLength, Map<String, Object> newParameter) {
        if (breadCrumb != null && breadCrumb.getData() != null && !CollectionUtils.isEmpty(breadCrumb.getData())) {
            List<BreadCrumbNode> breadCrumbNodes = breadCrumb.getData();
            for (BreadCrumbNode node : breadCrumbNodes) {
                Map<String, Object> nodeRawData = node.getRawData();
                newParameter = (Map<String, Object>) nodeRawData.get("currentNewParameter_" + crumbLength);
                if (CollectionUtils.isEmpty(newParameter) && nodeRawData.get("currentCrumb") != null) {
                    newParameter = searchCurrentNewParameter(JsonUtil.objectToJavaObject(nodeRawData.get("currentCrumb"), BreadCrumb.class), crumbLength, newParameter);
                } else {
                    if (!CollectionUtils.isEmpty(newParameter)) {
                        return newParameter;
                    }
                }
            }
        }
        return newParameter;
    }
}
