package com.digiwin.mobile.mobileuibot.core.component.briefingexpress;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wuyang
 * @desc 简报速递组件（业务型组件）
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BriefingExpress extends BaseMobileComponent {

    private static final long serialVersionUID = -7956414013683086111L;
    //todo yanfeng 先修改添加 _1，回头在改回去：BRIEFING_EXPRESS
    public static final String COMPONENT_TYPE = "BRIEFING_EXPRESS_1";

    /**
     * 标题
     */
    private String title;
    private String subTitle;
    private List<TitleParam> subTitleParams = new ArrayList<>(1);
    private List<BriefingExpressData> datas = new ArrayList(2);
    /**
     * 是否出现"显示更多"的按钮,默认为false
     */
    private Boolean hasShowMore = false;
    /**
     * 显示更多的文本
     */
    private String showMoreText;
    /**
     * 显示的数据笔数
     */
    private Integer showDataNum = 2;


    @Override

    public String returnComponentType() {
        return BriefingExpress.COMPONENT_TYPE;
    }


    public void setSubTitle(BriefingExpress briefingExpress, int unReadNums,
                            String locale, LocaleService localeService) {
        briefingExpress.setSubTitle(localeService.getLanguageValue(locale, briefingExpress.getSubTitle()));
        List<TitleParam> titleParams = briefingExpress.getSubTitleParams();
        for (TitleParam titleParam : titleParams) {
            if (TitleParamTypeEnum.UNREAD.getType().equals(titleParam.getValue())) {
                titleParam.setValue(String.valueOf(unReadNums));
            }
        }
    }
}
