package com.digiwin.mobile.mobileuibot.core.component.business;

import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import org.springframework.util.Assert;

import java.io.Serializable;

/**
 * <p>功能描述：详情页基础信息</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DetailPage
 * @Author: Zaregoto
 * @Date: 2021/10/14 22:47
 */
public class DetailPage implements Serializable {
    private static final long serialVersionUID = 7975512714850195355L;

    private String dataId;
    private ApiExtraParameter extraParameter;
    private String pageId;
    private ApiRawData rawData;

    public DetailPage() {
    }

    public static DetailPage create(String locale, String dataId, ApiExtraParameter extraParameter, String pageId) {
        Assert.notNull(dataId, "dataId must not null!");
        Assert.notNull(extraParameter, "ApiExtraParameter must not null!");
        Assert.notNull(pageId, "pageId must not null!");

        DetailPage detailPage = new DetailPage();
        detailPage.setDataId(dataId);
        detailPage.setExtraParameter(extraParameter);
        detailPage.setPageId(pageId);

        return detailPage;
    }
    public static DetailPage create(String locale, String dataId, ApiExtraParameter extraParameter, String pageId,ApiRawData rawData) {
        Assert.notNull(dataId, "dataId must not null!");
        Assert.notNull(extraParameter, "ApiExtraParameter must not null!");
        Assert.notNull(pageId, "pageId must not null!");

        DetailPage detailPage = new DetailPage();
        detailPage.setDataId(dataId);
        detailPage.setExtraParameter(extraParameter);
        detailPage.setPageId(pageId);
        detailPage.setRawData(rawData);

        return detailPage;
    }

    public String getDataId() {
        return dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public ApiExtraParameter getExtraParameter() {
        return extraParameter;
    }

    public void setExtraParameter(ApiExtraParameter extraParameter) {
        this.extraParameter = extraParameter;
    }

    public String getPageId() {
        return pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public ApiRawData getRawData() {
        return rawData;
    }

    public void setRawData(ApiRawData rawData) {
        this.rawData = rawData;
    }
}
