package com.digiwin.mobile.mobileuibot.core.component.business.bizapproval;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Tab
 * @Author: Zaregoto
 * @Date: 2021/5/20 11:53
 */
@Data
public abstract class BaseTab<T extends MobileComponent> extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = -7345447408984013170L;

    protected String name;
    protected String desc;
    protected T content;
    /**
     * tab签滚动模式
     */
    private Integer mScrollMode = CustomTabScrollModeEnum.CONTENT_SCROLL.getMode();

    public BaseTab() {
    }

    public BaseTab(String name) {
        this.name = name;
    }

    public BaseTab(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public T getContent() {
        return content;
    }

    public void setContent(T content) {
        this.content = content;
    }
}
