package com.digiwin.mobile.mobileuibot.core.component.business.bizapproval;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinition;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：签核型任务明细条目的对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BizApprovalDataItem
 * @Author: Zaregoto
 * @Date: 2021/5/23 22:38
 */
public class BizApprovalDataItem extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = 7118943813705734168L;
    public static final String COMPONENT_TYPE = "BIZ_APPROVAL_DATA_ITEM";

    /**
     * 放概要字段
     */
    private List<Field> content = new ArrayList<>(5);

    /**
     * 放次要字段
     */
    private List<Field> hideContent = new ArrayList<>(20);

    /**
     *  放标题字段+重要字段
     */
    private BizApprovalDataItemTitle title;

    public BizApprovalDataItem() {
    }

    public static BizApprovalDataItem create(String locale, List<UiBotTableColumn> tableColumns,
        Map<String, Object> bizData, Map<String, ColumnTag> columnTagMap) {
        List<String> leftTitle = new ArrayList<>();
        List<String> rightTitle = new ArrayList<>();
        BizApprovalDataItem dataItem = new BizApprovalDataItem();
        tableColumns.forEach(column -> {
            String schema = column.getSchema();
            Optional<Object> optBizDataValue = Optional.ofNullable(bizData.get(schema));
            // bizData的业务数据内没有的字段，则是tableColumn自己逻辑处理上需要使用的字段，没有业务资料，所以移动端过滤掉，不展示
            if (optBizDataValue.isPresent())  {
                String bizDataValue = optBizDataValue.get().toString();
                // 根据字段打的tag区分放的位置
                String columnTagCode = Optional.ofNullable(columnTagMap.get(schema))
                    .map(ColumnTag::getTagDefinition)
                    .map(ColumnTagDefinition::getCode)
                    .orElse("");
                Field itemContentField = Field.create(column, column.getValueForDisplay(bizData));
                if (columnTagCode.equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode())) {
                    leftTitle.add(bizDataValue);
                } else if (columnTagCode.equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_IMPORTANT.getCode())) {
                    rightTitle.add(bizDataValue);
                } else if (columnTagCode.equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode())) {
                    // 只读的话，空值，移动不显示
                    if (!itemContentField.getValue().trim().isEmpty()) {
                        dataItem.getContent().add(itemContentField);
                    }
                } else {
                    // 只读的话，空值，移动不显示
                    if (!itemContentField.getValue().trim().isEmpty()) {
                        dataItem.getHideContent().add(itemContentField);
                    }
                }
            }
        });
        dataItem.setTitle(BizApprovalDataItemTitle.create(
            locale, leftTitle, rightTitle.isEmpty() ? "" : rightTitle.get(0)));

        return dataItem;

    }

    public List<Field> getContent() {
        return content;
    }

    public void setContent(List<Field> content) {
        this.content = content;
    }

    public List<Field> getHideContent() {
        return hideContent;
    }

    public void setHideContent(List<Field> hideContent) {
        this.hideContent = hideContent;
    }

    public BizApprovalDataItemTitle getTitle() {
        return title;
    }

    public void setTitle(BizApprovalDataItemTitle title) {
        this.title = title;
    }

    @Override public String returnComponentType() {
        return BizApprovalDataItem.COMPONENT_TYPE;
    }
}
