package com.digiwin.mobile.mobileuibot.core.component.business.bizapproval;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import org.springframework.util.Assert;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：签核型任务明细条目的对象的标题对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BizApprovalDataItemTitle
 * @Author: Zaregoto
 * @Date: 2021/5/23 22:39
 */
public class BizApprovalDataItemTitle extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = -7619337342658696785L;
    public static final String COMPONENT_TYPE = "BIZ_APPROVAL_DATA_ITEM_TITLE";

    private List<String> leftTitle;
    private String rightTitle;
    /**
     * 放在左侧标题右边的标签
     */
    private List<Tag> leftTags;

    public BizApprovalDataItemTitle() {
    }

    public static BizApprovalDataItemTitle create(String locale, List<String> leftTitle, String rightTitle) {
        Assert.notNull(leftTitle, "lefttitle in dataitem cannot be null");
        BizApprovalDataItemTitle title = new BizApprovalDataItemTitle();
        if (leftTitle.size() > 3) {
            title.setLeftTitle(leftTitle.subList(0, 3));
        } else {
            title.setLeftTitle(leftTitle);
        }
        title.setRightTitle(rightTitle);

        return title;
    }

    public static BizApprovalDataItemTitle create(String locale, List<String> leftTitle, String rightTitle, List<Tag> leftTags) {
        BizApprovalDataItemTitle title = BizApprovalDataItemTitle.create(locale, leftTitle, rightTitle);
        title.setLeftTags(leftTags);
        return title;
    }

    public List<String> getLeftTitle() {
        return leftTitle;
    }

    public void setLeftTitle(List<String> leftTitle) {
        this.leftTitle = leftTitle;
    }

    public String getRightTitle() {
        return rightTitle;
    }

    public void setRightTitle(String rightTitle) {
        this.rightTitle = rightTitle;
    }

    public void addToLeftTitle(String otherTitle) {
        this.leftTitle.add(otherTitle);
    }

    public List<Tag> getLeftTags() {
        return leftTags;
    }

    public void setLeftTags(List<Tag> leftTags) {
        this.leftTags = leftTags;
    }

    @Override
    public String returnComponentType() {
        return BizApprovalDataItemTitle.COMPONENT_TYPE;
    }
}
