package com.digiwin.mobile.mobileuibot.core.component.business.bizapproval;

import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.business.DetailPage;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.PcUiBotPageDataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：签核型任务明细条目的第2版对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BizApprovalDataItemV2
 * @Author: Zaregoto
 * @Date: 2021/10/14 1:29
 */
public class BizApprovalDataItemV2 implements Serializable {
    private static final long serialVersionUID = 5415385051196868253L;
    public static final String COMPONENT_TYPE = "BIZ_APPROVAL_DATA_ITEM_V2";

    /**
     * 自动选择字段展示时的规则：标题最多展示1个字段
     */
    private static final int MAX_TITLE_FILED_AUTOMATED_DISPLAY_COUNT = 1;

    /**
     * 自动选择字段展示时的规则：概要最多展示3个字段
     */
    private static final int MAX_PROFILE_FILED_AUTOMATED_DISPLAY_COUNT = 4;

    /**
     * 自动选择字段展示时的规则：概要最多展示4个字段--PWD 需求
     */
    private static final int MAX_PROFILE_FILED_AUTOMATED_PWD_DISPLAY_COUNT = 5;

    /**
     * 自动选择字段展示时的规则：标题+概要最多展示的字段数量
     * 第1个只读字段做为标题字段
     * 第2、3、4只读则作为概要字段显示
     */
    private static final int MAX_FIELD_AUTOMATED_DISPLAY_COUNT = MAX_TITLE_FILED_AUTOMATED_DISPLAY_COUNT + MAX_PROFILE_FILED_AUTOMATED_DISPLAY_COUNT;

    /**
     * 概要字段
     */
    private List<Field> content = new ArrayList<>(5);

    private DetailPage detailPage;

    /**
     * 标题字段+重要字段
     */
    private BizApprovalDataItemTitle title;

    public BizApprovalDataItemV2() {
    }


    /**
     * 根据PC端数据创建签核条目组件
     *
     * @param apiRequest    请求对象
     * @param pcUibotModel  PC端UiBot对象
     * @param bizDataSchema pageData中业务数据的属性名称
     * @param columns       业务栏位列表
     * @param bizData       业务数据
     * @param columnTags    业务栏位清单
     * @return 签核条目组件
     */
    private static BizApprovalDataItemV2 create(ApiRequest apiRequest,
                                                UiBotModel pcUibotModel, String bizDataSchema,
                                                List<UiBotTableColumn> columns, Map<String, Object> bizData,
                                                List<ColumnTag> columnTags) {
        String locale = apiRequest.getLocale();
        String dataId = apiRequest.getDataId();
        ApiExtraParameter apiExtraParameter = apiRequest.getExtraParameter();

        int fieldUsedCount = 0;
        // 左标题字段值清单=有tag的字段+无tag自动处理的的字段
        List<String> leftTitleFieldValuesTagged = new ArrayList<>();
        // 右标题重要字段值清单
        List<String> rightTitleImportantFieldValues = new ArrayList<>();
        // 概要字段清单=有tag的字段+无tag自动处理的字段
        List<Field> profileFieldsTagged = new ArrayList<>();

        // 自动模式选择的字段清单
        List<Field> fieldsAutomated = new ArrayList<>();

        BizApprovalDataItemV2 dataItem = new BizApprovalDataItemV2();

        /**
         * 先对数据做预处理
         */
        // 将list转换为map，加速后续处理效率.
        // key为schema，value为ColumnTag对象
        Map<String, ColumnTag> columnTagMap = columnTags.stream().collect(Collectors.toMap(ColumnTag::getSchema, c -> c, (c1, c2) -> c1));
        // key为schema，value为UiBotTableColumn对象
        Map<String, UiBotTableColumn> columnMap = columns.stream().collect(Collectors.toMap(UiBotTableColumn::getSchema, c -> c, (c1, c2) -> c1));
        // 查找标记为"标题"的字段，并以序号排序
        List<ColumnTag> titleColumnTags = columnTags.stream().filter(
                        ct -> ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode()
                                .equalsIgnoreCase(ct.getTagDefinition().getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        // 查找标记为"重要"的字段，并以序号排序
        List<ColumnTag> importantColumnTags = columnTags.stream().filter(
                        ct -> ColumnTagDefinitionCodeEnum.DISPLAY_IMPORTANT.getCode()
                                .equalsIgnoreCase(ct.getTagDefinition().getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        // 查找标记为"概要"的字段，并以序号排序
        List<ColumnTag> profileColumnTags = columnTags.stream().filter(
                        ct -> ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode()
                                .equalsIgnoreCase(ct.getTagDefinition().getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        /**
         * 正式处理
         *  先针对打了TAG的字段做展示处理
         *  再判断组件中已使用的字段数量是否已经达到上限，若没有则使用剩下未打TAG的、只读的字段做展示处理
         */
        // 标题字段
        titleColumnTags.forEach(columnTag -> {
            UiBotTableColumn tableColumn = columnMap.get(columnTag.getSchema());
            if (null != tableColumn) {
                String columnValue = tableColumn.getValueForDisplay(bizData);
                Field itemContentField = Field.create(tableColumn, columnValue);
                // 只读的话，空值，移动不显示
                if (!itemContentField.getValue().trim().isEmpty()) {
                    leftTitleFieldValuesTagged.add(itemContentField.getValue());
                }
            }
        });
        // 重要字段
        importantColumnTags.forEach(columnTag -> {
            UiBotTableColumn tableColumn = columnMap.get(columnTag.getSchema());
            if (null != tableColumn) {
                String columnValue = tableColumn.getValueForDisplay(bizData);
                Field itemContentField = Field.create(tableColumn, columnValue);
                // 只读的话，空值，移动不显示
                if (!itemContentField.getValue().trim().isEmpty()) {
                    rightTitleImportantFieldValues.add(itemContentField.getValue());
                }
            }
        });
        // 概要字段
        profileColumnTags.forEach(columnTag -> {
            UiBotTableColumn tableColumn = columnMap.get(columnTag.getSchema());
            if (null != tableColumn) {
                String columnValue = tableColumn.getValueForDisplay(bizData);
                Field itemContentField = Field.create(tableColumn, columnValue);
                // 只读的话，空值，移动不显示
                if (!itemContentField.getValue().trim().isEmpty()) {
                    profileFieldsTagged.add(itemContentField);
                }
            }
        });

        String tmActivityId = Optional.ofNullable(apiRequest.getExtraParameter()).map(ApiExtraParameter::getTmActivityId).orElse("");
        String tmPattern = Optional.ofNullable(apiRequest.getExtraParameter()).map(ApiExtraParameter::getTmPattern).orElse("");
        String tmCategory = Optional.ofNullable(apiRequest.getExtraParameter()).map(ApiExtraParameter::getTmCategory).orElse("");
        // 无tag字段处理
        if ("PurchaseApproval_PWD".equals(tmActivityId)) {
            Iterator<UiBotTableColumn> iterator = columns.iterator();
            while (iterator.hasNext()) {
                UiBotTableColumn column = iterator.next();
                if ("is_inquiry".equals(column.getSchema()) ||
                        "price_fluctuate_margin".equals(column.getSchema())) {
                    iterator.remove();
                }
            }
        }
        for (UiBotTableColumn column : columns) {
            String columnSchema = column.getSchema();
            if (columnTagMap.containsKey(columnSchema) || column.canEdit()) {
                // 随心控(人工型：code+_task_manual;审核型：code+_task_approve) 的卡，可编辑栏位也显示
                // 模型驱动2.0签核卡也需要支持
                if (!(TaskStringUtil.isBizSmartAdjust(tmActivityId) || TaskStringUtil.isBizDataEntryDriven(tmPattern, tmCategory))) {
                    continue;
                }
            }
            String columnValue = column.getValueForDisplay(bizData);
            Field itemContentField = Field.create(column, columnValue);
            // 只读的话，空值，移动不显示
            if (itemContentField.getValue().trim().isEmpty()) {
                continue;
            }
            fieldsAutomated.add(itemContentField);

            fieldUsedCount++;
            if (fieldUsedCount == (MAX_TITLE_FILED_AUTOMATED_DISPLAY_COUNT + getMaxProfileFieldAutomatedDisplayCount(tmActivityId))) {
                break;
            }
        }
        // 依最大展示数量,将打tag的标题字段与不打tag的标题字段合并
        // 如果打tag的标题字段少于MAX_TITLE_FILED_AUTOMATED_DISPLAY_COUNT，则追加自动模式选择的字段，并且更新剩余的自动选择字段清单
        List<String> leftTitleFieldValues = new ArrayList<>(leftTitleFieldValuesTagged);
        if (leftTitleFieldValues.size() < MAX_TITLE_FILED_AUTOMATED_DISPLAY_COUNT) {
            int addCount = MAX_TITLE_FILED_AUTOMATED_DISPLAY_COUNT - leftTitleFieldValues.size();
            // 防护
            if (addCount > fieldsAutomated.size()) {
                addCount = fieldsAutomated.size();
            }
            leftTitleFieldValues.addAll(fieldsAutomated.subList(0, addCount)
                    .stream().map(Field::getValue).collect(Collectors.toList())
            );
            fieldsAutomated = fieldsAutomated.subList(addCount, fieldsAutomated.size());
        }

        // 依最大展示数量将打tag的概要字段与不打tag的概要字段合并
        // 如果打tag的概要字段少于MAX_PROFILE_FILED_AUTOMATED_DISPLAY_COUNT，则追加自动选择的字段，并且更新剩余的自动选择字段清单
        List<Field> profileFields = new ArrayList<>(profileFieldsTagged);
        if (profileFields.size() < getMaxProfileFieldAutomatedDisplayCount(tmActivityId)) {
            int addCount = getMaxProfileFieldAutomatedDisplayCount(tmActivityId) - profileFields.size();
            // 防护
            if (addCount > fieldsAutomated.size()) {
                addCount = fieldsAutomated.size();
            }
            profileFields.addAll(fieldsAutomated.subList(0, addCount));
            fieldsAutomated = fieldsAutomated.subList(addCount, fieldsAutomated.size());
        }
        if ("pccStopProjectApprove".equals(tmActivityId)) {
            List approve = new ArrayList();
            for (Field field : fieldsAutomated) {
                if ("approve_action".equals(field.getSchema())) {
                    approve.add(field);
                    profileFields.addAll(approve);
                    if (profileFields.size() >= 2 && "change_reason".equals((profileFields.get(profileFields.size() - 2)).getSchema())) {
                        Field tempField = profileFields.get(profileFields.size() - 1);
                        profileFields.set(profileFields.size() - 1, profileFields.get(profileFields.size() - 2));
                        profileFields.set(profileFields.size() - 2, tempField);
                    }
                    break;
                }
            }
        }
        if (bizData.get("__PRICE") != null) {
            //erp签核采购单定制处理，"__PRICE"值为"1"时，schema为"PRICE"的栏位value标红
            String priceType = bizData.get("__PRICE").toString();
            if ("1".equals(priceType)) {
                for (Field field : profileFields) {
                    if ("PRICE".equals(field.getSchema())) {
                        field.setValueStyleType(4);
                    }
                }
            }
        }

        dataItem.getContent().addAll(profileFields);

        // 所有字段都在detailPage加载的时候处理。
        ApiExtraParameter newApiExtraParameter = ApiExtraParameter.copyFromAnother(apiExtraParameter);
        newApiExtraParameter.setDataKey(PcUiBotPageDataUtil.getBizDataKey(pcUibotModel, bizDataSchema, bizData));
        newApiExtraParameter.setForItemDetail(true);
        dataItem.setDetailPage(DetailPage.create(locale,
                dataId,
                newApiExtraParameter,
                PageSettingIdPresetEnum.MOBILE_ATHENA_DETAIL_ITEM_DETAIL.toString()));

        BizApprovalDataItemTitle title = BizApprovalDataItemTitle.create(locale,
                leftTitleFieldValues, rightTitleImportantFieldValues.isEmpty() ? "" : rightTitleImportantFieldValues.get(0));

        //erp签核采购单定制处理，"__ITEM_CODE"值为"1"时，标题右边展示"首购"标签
        if (bizData.get("__ITEM_CODE") != null) {
            String itemCodeType = bizData.get("__ITEM_CODE").toString();
            if ("1".equals(itemCodeType)) {
                Tag tag = Tag.createBlueBgdWriteTextStateTag(LocaleUtil.getMobileTextByKey(locale, "首购"));
                List<Tag> tagList = new ArrayList<>();
                tagList.add(tag);
                title.setLeftTags(tagList);
            }
        }
        dataItem.setTitle(title);
        return dataItem;
    }


    private static int getMaxProfileFieldAutomatedDisplayCount(String tmActivityId) {
        if ("PurchaseApproval_PWD".equals(tmActivityId)) {
            return MAX_PROFILE_FILED_AUTOMATED_PWD_DISPLAY_COUNT;
        } else {
            return MAX_PROFILE_FILED_AUTOMATED_DISPLAY_COUNT;
        }
    }

    private static BizApprovalDataItemV2 create(ApiRequest apiRequest,
                                                UiBotModel pcUibotModel, String bizDataSchema,
                                                List<UiBotTableColumn> columns, Map<String, Object> bizData,
                                                List<ColumnTag> columnTags, List<ParseFieldData> fieldDataList) {
        BizApprovalDataItemV2 bizApprovalDataItemV2 = create(apiRequest, pcUibotModel, bizDataSchema, columns, bizData, columnTags);
        DetailPage detailPage = new DetailPage();
        ApiRawData rawData = new ApiRawData();
        rawData.put("data", fieldDataList);
        detailPage.setRawData(rawData);
        detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ECN_PROJECT_ITEM_DETAIL.toString());
        detailPage.setDataId("");
        bizApprovalDataItemV2.setDetailPage(detailPage);
        return bizApprovalDataItemV2;
    }

    /**
     * 根据PC端TABLE组件创建签核条目组件
     *
     * @param apiRequest    请求对象
     * @param pcUibotModel  PC端UiBot对象
     * @param bizDataSchema pageData中业务数据的属性名称
     * @param tableColumns  表格栏位列表
     * @param bizData       业务数据
     * @param columnTags    业务栏位清单
     * @return 签核条目组件
     */
    public static BizApprovalDataItemV2 createWithPcTable(ApiRequest apiRequest,
                                                          UiBotModel pcUibotModel, String bizDataSchema,
                                                          List<UiBotTableColumn> tableColumns, Map<String, Object> bizData,
                                                          List<ColumnTag> columnTags) {
        return create(apiRequest, pcUibotModel, bizDataSchema, tableColumns, bizData, columnTags);
    }

    /**
     * 根据PC端TABS组件创建签核条目组件
     *
     * @param apiRequest
     * @param pcUibotModel
     * @param bizDataSchema
     * @param tableColumns
     * @param bizData
     * @param columnTags
     * @param fieldDataList
     * @param drawerUiBotTableColumnDefinition 子单身columnDefs
     * @return
     */
    public static BizApprovalDataItemV2 createWithPcTABS(ApiRequest apiRequest,
                                                         UiBotModel pcUibotModel, String bizDataSchema,
                                                         List<UiBotTableColumn> tableColumns, Map<String, Object> bizData,
                                                         List<ColumnTag> columnTags, List<ParseFieldData> fieldDataList,
                                                         List<UiBotTableColumnDefinition> drawerUiBotTableColumnDefinition) {
        BizApprovalDataItemV2 bizApprovalDataItemV2 = create(apiRequest, pcUibotModel, bizDataSchema, tableColumns, bizData, columnTags);
        DetailPage detailPage = new DetailPage();
        ApiRawData rawData = new ApiRawData();
        List<UiBotLayout> group = null;
        if (!CollectionUtils.isEmpty(drawerUiBotTableColumnDefinition)) {
            List<UiBotTableColumn> columns = drawerUiBotTableColumnDefinition.get(0).getColumns();
            if (!CollectionUtils.isEmpty(columns)) {
                group = columns.get(0).getGroup();
            }
        }
        if (CollectionUtils.isEmpty(group)) {
            // 当不存在子单身时，条目详情全部展示--走原有逻辑
            detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ECN_PROJECT_ITEM_DETAIL.name());
        } else {
            // 当存在子单身时，条目详情默认收起
            detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_MY_BIZ_APPROVAL_TASK_ITEM_DETAIL.name());
            rawData.put("layout", group);
            rawData.put("pageData", bizData);
        }
        // 单身数据
        rawData.put("data", fieldDataList);
        rawData.put("tableColumns", tableColumns);
        detailPage.setRawData(rawData);
        detailPage.setDataId("");
        bizApprovalDataItemV2.setDetailPage(detailPage);
        return bizApprovalDataItemV2;
    }

    /**
     * 重写createWithPcTable方法，添加fieldDataList参数，提供条目详情跳转所需数据
     * （不太好，fieldDataList跟uiBotModel、bizData、tableColumns数据重复，虽然但是就先这样吧。。）
     *
     * @param apiRequest
     * @param pcUibotModel
     * @param bizDataSchema
     * @param tableColumns
     * @param bizData
     * @param columnTags
     * @param fieldDataList
     * @return
     */
    public static BizApprovalDataItemV2 createWithPcTable(ApiRequest apiRequest,
                                                          UiBotModel pcUibotModel, String bizDataSchema,
                                                          List<UiBotTableColumn> tableColumns, Map<String, Object> bizData,
                                                          List<ColumnTag> columnTags, List<ParseFieldData> fieldDataList) {
        return create(apiRequest, pcUibotModel, bizDataSchema, tableColumns, bizData, columnTags, fieldDataList);
    }

    /**
     * 根据PC端FORM_LIST创建签核条目组件
     *
     * @param apiRequest    请求对象
     * @param pcUibotModel  PC端UiBot对象
     * @param bizDataSchema pageData中业务数据的属性名称
     * @param fields        表格栏位列表
     * @param bizData       业务数据
     * @param columnTags    业务栏位tag清单
     * @return 签核条目组件
     */
    public static BizApprovalDataItemV2 createWithPcFormList(ApiRequest apiRequest,
                                                             UiBotModel pcUibotModel, String bizDataSchema,
                                                             List<UiBotLayout> fields, Map<String, Object> bizData, List<ColumnTag> columnTags) {
        List<UiBotTableColumn> tableColumns = fields.stream().map(UiBotLayout::parseToTableColumn).collect(Collectors.toList());
        return create(apiRequest, pcUibotModel, bizDataSchema, tableColumns, bizData, columnTags);
    }

    public List<Field> getContent() {
        return content;
    }

    public void setContent(List<Field> content) {
        this.content = content;
    }

    public DetailPage getDetailPage() {
        return detailPage;
    }

    public void setDetailPage(DetailPage detailPage) {
        this.detailPage = detailPage;
    }

    public BizApprovalDataItemTitle getTitle() {
        return title;
    }

    public void setTitle(BizApprovalDataItemTitle title) {
        this.title = title;
    }
}
