package com.digiwin.mobile.mobileuibot.core.component.business.bizapproval;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * <p>功能描述：签核型任务明细列表对象，扩展自ArrayList</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BizApprovalDataList
 * @Author: Zaregoto
 * @Date: 2021/5/23 22:36
 */
public class BizApprovalDataList extends ArrayList<BizApprovalDataItemV2> implements
    MobileComponent, Serializable {
    private static final long serialVersionUID = -1998905049210957605L;
    public static final String COMPONENT_TYPE = "BIZ_APPROVAL_DATA_LIST";

    /**
     * 组件运行时UUID
     */
    private String cmptUuid;

    public BizApprovalDataList() {
        this.cmptUuid = UUIDUtil.getUuid();
    }

    public String getCmptUuid() {
        return cmptUuid;
    }

    public void setCmptUuid(String cmptUuid) {
        this.cmptUuid = cmptUuid;
    }

    @Override public String returnComponentType() {
        return BizApprovalDataList.COMPONENT_TYPE;
    }
}
