package com.digiwin.mobile.mobileuibot.core.component.business.bizapproval;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableScriptFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.TableUiBotParser;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.script.Invocable;
import javax.script.ScriptException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BizApprovalTabBuilder
 * @Author: Zaregoto
 * @Date: 2021/5/23 23:09
 */
@Component("bizApprovalTabBuilder")
public class BizApprovalTabBuilder implements MobileComponentBuilder<BizApprovalTabList> {

    @Autowired
    private ColumnTagService columnTagService;

    @Autowired
    private LocaleService localeService;

    @Override
    public String getMobileComponentType() {
        return "TABS";
    }

    @Override
    public BizApprovalTabList build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                    Class<BizApprovalTabList> clazz, Object... args) {
//        if (Arrays.asList("306430713937984","312687398920256","312765840027712").contains(apiRequest.getDataId()) && "test0934".equals(apiRequest.getUserId())) {
//            // wjw TODO: 2023/5/19 测试数据验证签核子单身
//            String data = FileUtil.readText(
//                    "static/wjw-approval-task-test-data.json");
//            pcUiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
//        }
        String locale = apiRequest.getLocale();
        List<String> parentLayoutTypeList = new ArrayList<>();
        parentLayoutTypeList.add("SPLIT_LAYOUT");
        parentLayoutTypeList.add("FORM_LIST");
        parentLayoutTypeList.add("FORMGROUP");
        parentLayoutTypeList.add("TABS");
        List<String> layoutTypeList = new ArrayList<>();
        layoutTypeList.add("TABLE");
        UiBotModel uiBotModel = pcUiBotModel.searchPcTargetModel(layoutTypeList, parentLayoutTypeList, false);

        // 找到实际明细数据的layout
        BizApprovalTabList resultList = null;
        if (uiBotModel.getLayout().isEmpty()) {
            return BizApprovalTabList.createEmpty();
        }
        //目前移动端只支持一个表格，有多个表格时仅展示第一个表
        UiBotLayout dataLayout = uiBotModel.getLayout().get(0);
        if (dataLayout.isTypeOfTable()) {
            resultList = this.getBizApprovalTabsWithPcTable(apiRequest, uiBotModel, locale, dataLayout, false);
        } else {
            resultList = BizApprovalTabList.createEmpty();
        }
        return resultList;
    }

    private BizApprovalTabList getBizApprovalTabsWithPcTable(ApiRequest apiRequest, UiBotModel pcUiBotModel,
                                                             String locale, UiBotLayout pcDataLayout,
                                                             Boolean isShowRealTabName) {
        List<UiBotTableColumnDefinition> tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return BizApprovalTabList.createEmpty();
        }
        // 删除 type=DRAWER_BUTTON 操作抽屉
        List<UiBotTableColumnDefinition> drawerUiBotTableColumnDefinition = tableColumnDefinitionList.stream()
                .filter(columnDefinition -> {
                    List<UiBotTableColumn> columns = columnDefinition.getColumns();
                    if (CollectionUtils.isEmpty(columns)) {
                        return false;
                    }
                    return columns.stream().anyMatch(c -> "DRAWER_BUTTON".equals(c.getType()));
                }).collect(Collectors.toList());
        tableColumnDefinitionList.removeAll(drawerUiBotTableColumnDefinition);

        // 分解出明细数据一行的字段列表
        List<UiBotTableColumn> tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions(tableColumnDefinitionList);

        String path = pcDataLayout.getPath();
        String schema = pcDataLayout.getSchema();
        boolean hasParentSchema = StringUtils.hasLength(pcUiBotModel.getParentSchema());
        // 因为是TABLE类型的layout，所以数据一定是数组
        List<Map<String, Object>> bizDataList = (List<Map<String, Object>>) pcUiBotModel.getPageData()
                .getBizDataByPathAndSchema(path, schema, hasParentSchema);
        List<List<ParseFieldData>> fieldDataListList = TableUiBotParser
                .parseTableUiBotData(pcDataLayout, pcUiBotModel.getPageData(), hasParentSchema);

        if (pcUiBotModel.getPageData().containsKey(path)) {
            if (CollectionUtils.isEmpty(bizDataList)) {
                return BizApprovalTabList.createEmpty();
            }
        }

        BizApprovalTabList bizApprovalTabList = new BizApprovalTabList();

        /*
        List<UiBotTableScriptFilter> scriptFilterList = pcDataLayout.getScriptFilters();
        if (scriptFilterList != null && !scriptFilterList.isEmpty()) {
            for (UiBotTableScriptFilter scriptFilter : scriptFilterList) {
                String title = scriptFilter.getTitle();
                String description = scriptFilter.getDescription();
                TabInBizApproval tab = new TabInBizApproval(title, description);
                DataListInBizApproval dataListInBizApproval = new DataListInBizApproval();
                tab.setContent(dataListInBizApproval);

                for (Map<String, Object> bizData : bizDataList) {
                    dataListInBizApproval.add(DataItemInBizApproval.create(locale, tableColumns, bizData));
                }
                tabInBizApprovalList.add(tab);
            }
        } else {
            TabInBizApproval tab = new TabInBizApproval(LocaleUtil.getTextByKey(locale,"全部"));
            DataListInBizApproval dataListInBizApproval = new DataListInBizApproval();
            tab.setContent(dataListInBizApproval);

            for (Map<String, Object> bizData : bizDataList) {
                dataListInBizApproval.add(DataItemInBizApproval.create(locale, tableColumns, bizData));
            }
            tabInBizApprovalList.add(tab);
        }
        */

        List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPath(schema);

        List<UiBotTableScriptFilter> scriptFilters = pcDataLayout.getScriptFilters();
        if (scriptFilters == null || scriptFilters.isEmpty()) {
            BizApprovalTab tab = new BizApprovalTab(LocaleUtil.getMobileTextByKey(locale, "全部"));
            if (isShowRealTabName) {
                String name = Optional.ofNullable(pcDataLayout.getTitle()).orElse(pcDataLayout.getHeaderName());
                if (StringUtils.hasLength(name)) {
                    tab.setName(localeService.getLanguageValue(locale, StringUtil.valueOf(name)));
                }
            }
            BizApprovalDataList bizApprovalDataList = new BizApprovalDataList();
            tab.setContent(bizApprovalDataList);
            for (int i = 0; i < bizDataList.size(); i++) {
                Map<String, Object> bizData = bizDataList.get(i);
                bizApprovalDataList.add(
                        BizApprovalDataItemV2.createWithPcTABS(apiRequest, pcUiBotModel, schema, tableColumns, bizData,
                                columnTagList, fieldDataListList.get(i), drawerUiBotTableColumnDefinition));
            }
            bizApprovalTabList.add(tab);
        } else {
            scriptFilters.forEach(scriptFilter -> {
                BizApprovalTab tab = new BizApprovalTab(scriptFilter.getTitle());
                tab.setDesc(scriptFilter.getDescription());
                BizApprovalDataList bizApprovalDataList = new BizApprovalDataList();
                tab.setContent(bizApprovalDataList);
                bizApprovalTabList.add(tab);
                String filterScript = scriptFilter.getFilterScript();
                if (StringUtils.hasLength(filterScript) && filterScript.contains("item.value.local_curr_amount>")) {
                    //签核任务用金额筛选关注数据，固定格式为 (item) => item.value.local_curr_amount>1000
                    Double amount = Double.parseDouble(filterScript.substring(filterScript.indexOf("item.value.local_curr_amount>") + 29));
                    if (amount != null) {
                        for (int i = 0; i < bizDataList.size(); i++) {
                            Map<String, Object> bizData = bizDataList.get(i);
                            Double currAmount = 0.0;
                            if (bizData.get("local_curr_amount") instanceof Integer) {
                                currAmount = 1.0 * (Integer) bizData.get("local_curr_amount");
                            } else {
                                currAmount = (Double) bizData.get("local_curr_amount");
                            }
                            if (currAmount != null && currAmount > amount) {
                                bizApprovalDataList.add(
                                        BizApprovalDataItemV2.createWithPcTable(apiRequest, pcUiBotModel, schema, tableColumns, bizData, columnTagList, fieldDataListList.get(i)));
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < bizDataList.size(); i++) {
                        Map<String, Object> bizData = bizDataList.get(i);
                        bizApprovalDataList.add(
                                BizApprovalDataItemV2.createWithPcTable(apiRequest, pcUiBotModel, schema, tableColumns, bizData, columnTagList, fieldDataListList.get(i)));
                    }
                }
            });
        }
        return bizApprovalTabList;
    }

    private BizApprovalTabList getBizApprovalTabsWithPcFormList(ApiRequest apiRequest, UiBotModel pcUiBotModel,
                                                                String locale, UiBotLayout pcDataLayout) {
        String schema = pcDataLayout.getSchema();
        // 因为是FORM_LIST类型的layout，所以数据一定是对象
        Map<String, Object> bizData = (Map<String, Object>) pcUiBotModel.getPageData().get(schema);
        Assert.notNull(bizData, "pagedata." + schema + " cannot be null");
        if (bizData.isEmpty()) {
            return BizApprovalTabList.createEmpty();
        }

        List<UiBotLayout> pcFieldLayoutList = pcDataLayout.decomposeFieldsWithPcFormList(null);

        BizApprovalTabList bizApprovalTabList = new BizApprovalTabList();
        BizApprovalTab tab = new BizApprovalTab(LocaleUtil.getMobileTextByKey(locale, "全部"));
        BizApprovalDataList bizApprovalDataList = new BizApprovalDataList();
        tab.setContent(bizApprovalDataList);

        List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPath(schema);

        bizApprovalDataList.add(
                BizApprovalDataItemV2.createWithPcFormList(apiRequest, pcUiBotModel, schema, pcFieldLayoutList, bizData, columnTagList));

        bizApprovalTabList.add(tab);

        return bizApprovalTabList;
    }

    public static void main(String[] args) {
//        System.out.println("test nashorn");
        doJs("moweijie");
    }

    public static Object doJs(String params) {
        String[] options = new String[]{"--language=es6"};
        NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
        NashornScriptEngine engine = (NashornScriptEngine) factory.getScriptEngine(options);
        InputStream inputStream = null;
        String js = "";
        try {
            ClassPathResource classPathResource = new ClassPathResource("sample.js");
            inputStream = classPathResource.getInputStream();
            byte[] buffer = new byte[inputStream.available()];
            inputStream.read(buffer);
            js = new String(buffer, StandardCharsets.UTF_8);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Object result = null;

        try {
            engine.eval(js);
            Invocable inv = engine;
            result = inv.invokeFunction("sayHi", params);
        } catch (ScriptException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 通过PC的uibotModel，解析PC组件TABS下所有的TABLE，构建移动tabs组件数据
     *
     * @param apiRequest
     * @param tabUiBotModel
     * @return
     */
    public BizApprovalTabList buildAllTabs(ApiRequest apiRequest, UiBotModel tabUiBotModel) {
        String locale = apiRequest.getLocale();
        List<String> parentLayoutTypeList = new ArrayList<>();
        parentLayoutTypeList.add("TABS");
        List<String> layoutTypeList = new ArrayList<>();
        layoutTypeList.add("TABLE");
        UiBotModel uiBotModel = tabUiBotModel.searchPcTargetModel(layoutTypeList, parentLayoutTypeList, false);

        // 找到实际明细数据的layout
        BizApprovalTabList resultList = BizApprovalTabList.createEmpty();
        if (uiBotModel.getLayout().isEmpty()) {
            return BizApprovalTabList.createEmpty();
        }
        /* 由于签核套件子单身 从上个页面传递过来的 UiBotPageData已经是下一层资料
         *  故设置 parentSchema 不为空（任意值），使 hasParentSchema=true，逻辑上不会使用path字段，直接使用schema字段查找数据
         */
        if (!PageSettingIdPresetEnum.MOBILE_MY_BIZ_DATA_ENTRY_DRIVEN_TASK_DETAIL.name().equals(apiRequest.getPageId())) {
            uiBotModel.setParentSchema("TABS");
        }
        for (UiBotLayout dataLayout : uiBotModel.getLayout()) {
            if (dataLayout.isTypeOfTable()) {
                resultList.addAll(this.getBizApprovalTabsWithPcTable(apiRequest, uiBotModel, locale, dataLayout, true));
            }
        }
        return resultList;
    }
}
