package com.digiwin.mobile.mobileuibot.core.component.business.bizprocess;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：标准任务处理界面的数据项模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BizProcessDataItem
 * @Author: Zaregoto
 * @Date: 2021/8/4 15:45
 */
public class BizProcessDataItem extends BaseMobileComponent implements Serializable {
    public static final String COMPONENT_TYPE = "MULTI_LEVEL_SUBMITTABLE_ITEM";
    private static final int ICON_DATA = 59040;
    private static final long serialVersionUID = -284270339184522205L;
    private String id;
    private String title;
    private Integer titleIconData;
    private String subtitle;
    private List<BizProcessSubDataItem> children;

    public BizProcessDataItem() {
    }

    public static BizProcessDataItem create(ApiRequest apiRequest,
        UiBotLayout bizProcessDataListLayout, String title, String subTitle,
        UiBotModel pcUiBotModel, List<Map<String, Object>> groupedDataList,
        List<UiBotTableColumn> tableColumns, List<ColumnTag> columnTagList,
        List<Rule> mobileRuleList) {

        BizProcessDataItem bizProcessDataItem = new BizProcessDataItem();
        // 使用数据项的标题和副标题作为id。因为当前对象还不代表实际业务数据对象，故可以不用业务对象
        bizProcessDataItem.setId(title + ";" + subTitle);

        bizProcessDataItem.setTitle(title);
        if (null != subTitle && !subTitle.isEmpty()) {
            bizProcessDataItem.setSubtitle(subTitle);
        }
        bizProcessDataItem.setTitleIconData(ICON_DATA);
        bizProcessDataItem.setChildren(
            BizProcessSubDataItem.createList(apiRequest, bizProcessDataListLayout, pcUiBotModel,
                groupedDataList, tableColumns, columnTagList, mobileRuleList));

        return bizProcessDataItem;
    }

    @Override public String returnComponentType() {
        return BizProcessDataItem.COMPONENT_TYPE;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getTitleIconData() {
        return titleIconData;
    }

    public void setTitleIconData(Integer titleIconData) {
        this.titleIconData = titleIconData;
    }

    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public List<BizProcessSubDataItem> getChildren() {
        return children;
    }

    public void setChildren(List<BizProcessSubDataItem> children) {
        this.children = children;
    }
}
