package com.digiwin.mobile.mobileuibot.core.component.business.bizprocess;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BizProcessDataListBuilder
 * @Author: Zaregoto
 * @Date: 2021/8/5 17:15
 */
@Component("bizProcessDataListBuilder")
public class BizProcessDataListBuilder
        implements MobileComponentBuilder<BizProcessDataList> {
    private static final Logger logger = LoggerFactory.getLogger(BizProcessDataListBuilder.class);

    @Autowired
    private RuleService ruleService;

    @Autowired
    private ColumnTagService columnTagService;

    @Override
    public String getMobileComponentType() {
        return BizProcessDataList.COMPONENT_TYPE;
    }

    @Override
    public BizProcessDataList build(ApiRequest apiRequest, PageSetting pageSetting,
                                    UiBotModel pcUiBotModel, Class<BizProcessDataList> clazz, Object... args) {
        Assert.noNullElements(args, "args must not null and not empty");
        Assert.isInstanceOf(UiBotLayout.class, args[0],
                "args[0] must be instance of UiBotLayout.class!");

        UiBotLayout bizProcessDataListLayout = (UiBotLayout) args[0];

        UiBotTargetLayoutSearchResult layoutSearchResult = pcUiBotModel.searchPcTargetLayout();
        if (!layoutSearchResult.found()) {
            return BizProcessDataList.createEmpty();
        }

        UiBotLayout targetLayout = layoutSearchResult.getTargetUiBotLayout();
        List<UiBotAction> uiBotActions;
        String schema = pcUiBotModel.searchBizDataSchema();
        List<UiBotTableColumnDefinition> tableColumnDefinitionList;
        if (layoutSearchResult.getHasCustomData()) {
            if (null == targetLayout) {
                return BizProcessDataList.createEmpty();
            }
            if (null != targetLayout && null != targetLayout.getFinished()
                    && targetLayout.getFinished()) {
                return BizProcessDataList.createEmpty();
            }

            if (null == targetLayout.getActions() || targetLayout.getActions().isEmpty()) {
                return BizProcessDataList.createEmpty();
            }
            uiBotActions = targetLayout.getActions();
            tableColumnDefinitionList = bizProcessDataListLayout.getColumnDefs();
        } else {
            if (!"TABLE".equalsIgnoreCase(targetLayout.getType()) && !"GRID_TABLE".equalsIgnoreCase(
                    targetLayout.getType())) {
                return BizProcessDataList.createEmpty();
            }
            tableColumnDefinitionList = targetLayout.getColumnDefs();
            //            List<UiBotTableScriptFilter> scriptFilterList = targetLayout.getScriptFilters();
        }

        List<Map<String, Object>> bizDataList =
                (List<Map<String, Object>>) pcUiBotModel.getPageData().get(schema);
        Assert.notNull(bizDataList, "pagedata." + schema + " cannot be null");
        if (bizDataList.isEmpty()) {
            return BizProcessDataList.createEmpty();
        }
        if (tableColumnDefinitionList == null) {
            return BizProcessDataList.createEmpty();
        }
        // 分解出明细数据行的字段列表
        List<UiBotTableColumn> tableColumns =
                UiBotTableColumnDefinition.decomposeTableColumnDefinitions(tableColumnDefinitionList);

        // 获取栏位标记的tag
        List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPathAndPageId(schema, apiRequest.getPageId());

        // FIXME 获取移动端的规则库。后续需要和PC端UIBot负责人商量更合适的做法
        List<Rule> mobileRuleList = this.ruleService.findByRulePath(schema);

        return BizProcessDataList.create(apiRequest, bizProcessDataListLayout, bizDataList,
                pcUiBotModel, tableColumns, columnTagList, mobileRuleList);
    }
}
