package com.digiwin.mobile.mobileuibot.core.component.business.bizprocess;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.businesslogic.BusinessLogicHandler;
import com.digiwin.mobile.mobileuibot.businesslogic.BusinessLogicHandlerFactory;
import com.digiwin.mobile.mobileuibot.businesslogic.taskprocessecn.EcnWoChangeExceptionRuleLogic;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.math.MathUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.basic.ComparisonField;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.actionsheet.InputActionSheet;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：标准任务处理界面的数据项的子数据项模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BizProcessSubDataItem
 * @Author: Zaregoto
 * @Date: 2021/8/4 16:20
 */
public class BizProcessSubDataItem extends BaseMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "BIZ_PROCESS_SUB_DATA_ITEM";
    private static final long serialVersionUID = -2081946472933469862L;
    private static final String FIELD_VALUE_SPLITTER = " ";
    private String id;
    private String title;
    /**
     * 描述文字，展示数据的一些备注
     */
    private String description;
    private List<? super ComparisonField> summaryList;
    private List<ComparisonField> comparedData;
    private InputActionSheet operation;
    private UiBotModel buttonLayout;
    private Integer itemActionType;
    private String errorMessage;
    private BizProcessSubDataItemOperateData operateData;

    public BizProcessSubDataItem() {
    }
    //
    //    public static SubDataItemInBizProcess create(String locale, Map<String, Object> data, List<ColumnTag> columnTagList) {
    //
    //    }

    public static List<BizProcessSubDataItem> createList(ApiRequest apiRequest,
                                                         UiBotLayout bizProcessDataListLayout, UiBotModel pcUiBotModel,
                                                         List<Map<String, Object>> groupedDataList, List<UiBotTableColumn> tableColumns,
                                                         List<ColumnTag> columnTagList, List<Rule> mobileRuleList) {
        String locale = apiRequest.getLocale();
        List<BizProcessSubDataItem> generatedResult = new ArrayList<>();

        // List转Map，以字段名schema为key，减少循环
        Map<String, UiBotTableColumn> tableColumnMap = tableColumns.stream()
                .collect(Collectors.toMap(UiBotTableColumn::getSchema, c -> c, (c1, c2) -> c1));

        // 查找标记为"标题"的字段，并以序号排序
        List<ColumnTag> subjectTitleColumnTagList = columnTagList.stream().filter(
                        ct -> ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode()
                                .equalsIgnoreCase(ct.getTagDefinition().getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        Map<String, ColumnTag> subjectTitleColumnTagMap;
        List<UiBotTableColumn> subjectTitleColumnList;
        if (subjectTitleColumnTagList.isEmpty()) {
            // 没有作为对象标题的字段时，寻找第一对xxx_name与xxx_no的字段，作为对象标题的字段内容。
            // 拼接方式是：xxx_name字段的值[空格]xxx_no字段的值
//            subjectTitleColumnList = getSubjectTitleColumns(tableColumns);
            subjectTitleColumnTagMap = Collections.emptyMap();
            subjectTitleColumnList = Collections.emptyList();
        } else {
            // 转为map减少循环嵌套
            subjectTitleColumnTagMap = subjectTitleColumnTagList.stream()
                    .collect(Collectors.toMap(ColumnTag::getSchema, c -> c, (c1, c2) -> c1));
            subjectTitleColumnList = tableColumns.stream()
                    .filter(c -> subjectTitleColumnTagMap.containsKey(c.getSchema()))
                    .collect(Collectors.toList());
        }

        // 查找标记为“字段值比较”的字段，并以分组编号分组。有多少组就表示有多少个“字段值比较”的组件
        Map<Integer, List<ColumnTag>> compareValueTagGrouped = columnTagList.stream().filter(
                        ct -> ColumnTagDefinitionCodeEnum.DISPLAY_COMPARE_VALUE.getCode()
                                .equalsIgnoreCase(ct.getTagDefinition().getCode()))
                .collect(Collectors.groupingBy(ColumnTag::getGroupNo));

        // 查找标记为“新原值差异”的字段，并以分组编号分组。有多少组就表示有多少个“新原值差异”的组件
        Map<Integer, List<ColumnTag>> newOldValueDiffTagGrouped = columnTagList.stream().filter(
                        ct -> ColumnTagDefinitionCodeEnum.DISPLAY_NEW_OLD_DIFF.getCode()
                                .equalsIgnoreCase(ct.getTagDefinition().getCode()))
                .collect(Collectors.groupingBy(ColumnTag::getGroupNo));

        // 查找标记为“次要”的字段，并以序号排序
        List<ColumnTag> profileColumnTagList = columnTagList.stream().filter(
                        ct -> ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode()
                                .equalsIgnoreCase(ct.getTagDefinition().getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());

        // 查找标记为“长文本”的字段
        ColumnTag longTextTag = columnTagList.stream().filter(
                ct -> ColumnTagDefinitionCodeEnum.DISPLAY_LONGTEXT.getCode()
                        .equalsIgnoreCase(ct.getTagDefinition().getCode())).findFirst().orElse(null);
        UiBotTableColumn longTextColumn = longTextTag != null ?
                tableColumnMap.get(longTextTag.getSchema()) :
                UiBotTableColumn.createEmpty();

        // 查找可编辑，且为编辑方式为选择的字段。FIXME 目前不支持多个，如果有多个字段，先选第一个
        List<UiBotTableColumn> selectColumnList =
                tableColumns.stream().filter(UiBotTableColumn::canEditWithSelect)
                        .collect(Collectors.toList());
        UiBotTableColumn selectColumn =
                !selectColumnList.isEmpty() ? selectColumnList.get(0) : null;

        // 查找有开窗操作的字段列表
        List<UiBotTableColumn> openWindowColumnList =
                tableColumns.stream().filter(UiBotTableColumn::canEditWithOpenWindow)
                        .collect(Collectors.toList());

        BusinessLogicHandlerFactory businessLogicHandlerFactory = SpringContextHolder.getBean(BusinessLogicHandlerFactory.class);
        BusinessLogicHandler businessLogicHandler = businessLogicHandlerFactory.get(apiRequest.getPageId());
        for (Map<String, Object> groupedBizData : groupedDataList) {
            BizProcessSubDataItem bizProcessSubDataItem = new BizProcessSubDataItem();
            // 使用PC的UIBot返回的数据Key作为当前数据的ID
            bizProcessSubDataItem.setId(String.valueOf(groupedBizData.get("__DATA_KEY")));

            // 标题文本
            if (null != subjectTitleColumnList && !subjectTitleColumnList.isEmpty()) {
                String title = subjectTitleColumnList.stream()
                        .map(column -> {
                            Boolean showColumnLabel = subjectTitleColumnTagMap.get(column.getSchema()).getShowColumnLabel();
                            if (null == showColumnLabel || !showColumnLabel) {
                                return column.getValueForDisplay(groupedBizData);
                            } else {
                                return column.getHeaderName() + ":" + column.getValueForDisplay(groupedBizData);
                            }
                        })
                        .collect(Collectors.joining(FIELD_VALUE_SPLITTER));
                if (title.trim().isEmpty()) {
                    title = UiBotTableColumn.VALUE_EMPTY_SYMBOL;
                }
                bizProcessSubDataItem.setTitle(title);
            }
            // 字段值比较组件
            if (null != compareValueTagGrouped && !compareValueTagGrouped.isEmpty()) {
                List<ComparisonField> comparisonFieldList = new ArrayList<>();
                for (Integer groupNo : compareValueTagGrouped.keySet()) {
                    // 在当前分组内，依itemNo再分组出item清单。然后再循环生成一个个comparisonField
                    Map<Integer, List<ColumnTag>> compareValueGroupItemGrouped =
                            compareValueTagGrouped.get(groupNo).stream()
                                    .collect(Collectors.groupingBy(ColumnTag::getGroupItemNo));
                    for (Integer groupItemNo : compareValueGroupItemGrouped.keySet()) {
                        List<ColumnTag> groupItemColumnTagList =
                                compareValueGroupItemGrouped.get(groupItemNo);
                        Map<String, ColumnTag> groupItemColumnTagMappedByType =
                                groupItemColumnTagList.stream().collect(
                                        Collectors.toMap(ColumnTag::getType, c -> c, (c1, c2) -> c1));
                        ColumnTag columnTag = null;
                        // 设置新值与前缀文字
                        String newValueText = "", newValuePrefix = "";
                        UiBotTableColumn newValueColumn = null;
                        if (groupItemColumnTagMappedByType.containsKey(
                                ColumnTagTypeEnum.DISPLAY_COMPARE_VALUE_TYPE_NEW.getType())) {
                            columnTag = groupItemColumnTagMappedByType.get(
                                    ColumnTagTypeEnum.DISPLAY_COMPARE_VALUE_TYPE_NEW.getType());
                            newValueColumn = tableColumnMap.get(columnTag.getSchema());
                            if (null != newValueColumn) {
                                newValueText = newValueColumn.getValueForDisplay(groupedBizData);
                            }
                            newValuePrefix = LocaleUtil.getMobileTextByDatabaseKey(locale,
                                    columnTag.getValuePrefixText());
                        }
                        // 设置旧值与前缀文字
                        String oldValueText = "", oldValuePrefix = "";
                        UiBotTableColumn oldValueColumn = null;
                        if (groupItemColumnTagMappedByType.containsKey(
                                ColumnTagTypeEnum.DISPLAY_COMPARE_VALUE_TYPE_OLD.getType())) {
                            columnTag = groupItemColumnTagMappedByType.get(
                                    ColumnTagTypeEnum.DISPLAY_COMPARE_VALUE_TYPE_OLD.getType());
                            oldValueColumn = tableColumnMap.get(columnTag.getSchema());
                            if (null != oldValueColumn) {
                                oldValueText = oldValueColumn.getValueForDisplay(groupedBizData);
                            }
                            oldValuePrefix = LocaleUtil.getMobileTextByDatabaseKey(locale,
                                    columnTag.getValuePrefixText());

                            if (null != oldValueColumn && null != newValueColumn
                                    && oldValueColumn.isNumericData()
                                    && newValueColumn.isNumericData()) {
                                Number newValue =
                                        (Number) groupedBizData.get(newValueColumn.getSchema());
                                Number oldValue =
                                        (Number) groupedBizData.get(oldValueColumn.getSchema());
                                Double tempOldValue =
                                        newValue.doubleValue() - oldValue.doubleValue();
                                if (oldValueColumn.getThousandthPercentile()) {
                                    oldValueText = String.format("%+,f", tempOldValue);
                                } else {
                                    oldValueText = String.format("%+f", tempOldValue);
                                }
                                oldValueText =
                                        MathUtil.stripTrailingZerosInDoubleString(oldValueText);
                            }
                        }
                        // 设置展示label
                        String label = "";
                        if (null != columnTag) {
                            String columnTagLabel = columnTag.getLabel();
                            if (null != columnTagLabel && !columnTagLabel.isEmpty()) {
                                label =
                                        LocaleUtil.getMobileTextByDatabaseKey(locale, columnTagLabel);
                            } else if (null != newValueColumn && null != oldValueColumn) {
                                label = UiBotTableColumn.getMaxPublicSubNameBetweenColumns(
                                        newValueColumn.getHeaderName(), oldValueColumn.getHeaderName());
                            } else if (null != newValueColumn && null == oldValueColumn) {
                                label = newValueColumn.getHeaderName();
                            } else if (null == newValueColumn && null != oldValueColumn) {
                                label = oldValueColumn.getHeaderName();
                            } else {
                                label = "";
                            }
                        }
                        comparisonFieldList.add(
                                ComparisonField.create(Optional.ofNullable(label).orElse(""),
                                        Optional.ofNullable(oldValueColumn).map(UiBotTableColumn::getType)
                                                .orElse(null), "", true,
                                        Optional.ofNullable(oldValuePrefix).orElse(""),
                                        Optional.ofNullable(oldValueText).orElse(""),
                                        Optional.ofNullable(newValuePrefix).orElse(""),
                                        Optional.ofNullable(newValueText).orElse("")));
                    }
                }
                bizProcessSubDataItem.setComparedData(comparisonFieldList);
            }
            // 新原值差异组件
            if (null != newOldValueDiffTagGrouped && !newOldValueDiffTagGrouped.isEmpty()) {
                List<ComparisonField> comparisonFieldList = new ArrayList<>();
                for (Integer groupNo : newOldValueDiffTagGrouped.keySet()) {
                    List<ColumnTag> groupColumnTagList = newOldValueDiffTagGrouped.get(groupNo);
                    ColumnTag columnTag = null;
                    // 展示label
                    String label = "";
                    // 新值
                    String newValue = "", newValuePrefix = "";
                    UiBotTableColumn newValueColumn = null;
                    // 旧值
                    String oldValue = "", oldValuePrefix = "";
                    UiBotTableColumn oldValueColumn = null;

                    if (groupColumnTagList.size() > 1) {
                        Map<String, ColumnTag> groupColumnTagMappedByType =
                                groupColumnTagList.stream().collect(
                                        Collectors.toMap(ColumnTag::getType, c -> c, (c1, c2) -> c1));
                        // 设置新值与前缀文字
                        if (groupColumnTagMappedByType.containsKey(
                                ColumnTagTypeEnum.DISPLAY_NEW_OLD_DIFF_TYPE_NEW.getType())) {
                            columnTag = groupColumnTagMappedByType.get(
                                    ColumnTagTypeEnum.DISPLAY_NEW_OLD_DIFF_TYPE_NEW.getType());
                            newValueColumn = tableColumnMap.get(columnTag.getSchema());
                            if (null != newValueColumn) {
                                newValue = newValueColumn.getValueForDisplay(groupedBizData);
                            }
                            newValuePrefix = LocaleUtil.getMobileTextByDatabaseKey(locale,
                                    columnTag.getValuePrefixText());
                        }
                        // 设置旧值与前缀文字
                        if (groupColumnTagMappedByType.containsKey(
                                ColumnTagTypeEnum.DISPLAY_NEW_OLD_DIFF_TYPE_OLD.getType())) {
                            columnTag = groupColumnTagMappedByType.get(
                                    ColumnTagTypeEnum.DISPLAY_NEW_OLD_DIFF_TYPE_OLD.getType());
                            oldValueColumn = tableColumnMap.get(columnTag.getSchema());
                            if (null != oldValueColumn) {
                                oldValue = oldValueColumn.getValueForDisplay(groupedBizData);
                            }
                            oldValuePrefix = LocaleUtil.getMobileTextByDatabaseKey(locale,
                                    columnTag.getValuePrefixText());
                        }
                        // 设置展示label。如果在数据库有再设置label，则使用设置的值
                        if (null != columnTag) {
                            String columnTagLabel = columnTag.getLabel();
                            if (null != columnTagLabel && !columnTagLabel.isEmpty()) {
                                label =
                                        LocaleUtil.getMobileTextByDatabaseKey(locale, columnTagLabel);
                            } else if (null != newValueColumn && null != oldValueColumn) {
                                label = UiBotTableColumn.getMaxPublicSubNameBetweenColumns(
                                        newValueColumn.getHeaderName(), oldValueColumn.getHeaderName());
                            } else if (null != newValueColumn && null == oldValueColumn) {
                                label = newValueColumn.getHeaderName();
                            } else if (null == newValueColumn && null != oldValueColumn) {
                                label = oldValueColumn.getHeaderName();
                            } else {
                                label = "";
                            }
                        }
                        comparisonFieldList.add(
                                ComparisonField.create(Optional.ofNullable(label).orElse(""),
                                        Optional.ofNullable(oldValueColumn).map(UiBotTableColumn::getType)
                                                .orElse(null), "", true,
                                        Optional.ofNullable(oldValuePrefix).orElse(""),
                                        Optional.ofNullable(oldValue).orElse(""),
                                        Optional.ofNullable(newValuePrefix).orElse(""),
                                        Optional.ofNullable(newValue).orElse("")));
                    } else {
                        UiBotTableColumn column = null;
                        String value = "";
                        columnTag = groupColumnTagList.get(0);
                        if (columnTag.getType().equalsIgnoreCase(
                                ColumnTagTypeEnum.DISPLAY_NEW_OLD_DIFF_TYPE_NEW.getType())) {
                            column = tableColumnMap.get(columnTag.getSchema());
                        }
                        if (columnTag.getType().equalsIgnoreCase(
                                ColumnTagTypeEnum.DISPLAY_NEW_OLD_DIFF_TYPE_OLD.getType())) {
                            column = tableColumnMap.get(columnTag.getSchema());
                        }
                        if (null != column) {
                            value = column.getValueForDisplay(groupedBizData);
                            // 设置展示label。如果在数据库有再设置label，则使用设置的值
                            label = column.getHeaderName();
                            String columnTagLabel = columnTag.getLabel();
                            if (null != columnTagLabel && !columnTagLabel.isEmpty()) {
                                label =
                                        LocaleUtil.getMobileTextByDatabaseKey(locale, columnTagLabel);
                            }
                            comparisonFieldList.add(
                                    ComparisonField.create(Optional.ofNullable(label).orElse(""),
                                            Optional.ofNullable(column).map(UiBotTableColumn::getType)
                                                    .orElse(null), value, false, "", "", "", ""));
                        } else {
                            // 如果找不到栏位，则表示设置错误，最终不会展示。
                        }
                    }
                }
                bizProcessSubDataItem.setSummaryList(comparisonFieldList);
            }
            // 次要字段文本
            if (null != profileColumnTagList && !profileColumnTagList.isEmpty()) {
                List<ComparisonField> profileFieldList = new ArrayList<>();
                for (ColumnTag profileColumnTag : profileColumnTagList) {
                    UiBotTableColumn profileColumn =
                            tableColumnMap.get(profileColumnTag.getSchema());
                    // 展示label
                    String label =
                            Optional.ofNullable(profileColumn).map(UiBotTableColumn::getHeaderName)
                                    .orElse("");
                    profileFieldList.add(ComparisonField.create(label,
                            Optional.ofNullable(profileColumn).map(UiBotTableColumn::getType)
                                    .orElse(null), profileColumn.getValueForDisplay(groupedBizData), false,
                            "", ""));
                }
                bizProcessSubDataItem.addComparisonFieldToSummaryList(profileFieldList);
            }
            // 长文本组件
            if (null != longTextTag && null != longTextColumn) {
                String longText = longTextColumn.getValueForDisplay(groupedBizData);
                if (null != longText && !longText.isEmpty()) {
                    bizProcessSubDataItem.setDescription(
                            longTextColumn.getHeaderName() + ": " + longText);
                }
            }
            // 有选项的栏位
            if (null != selectColumn) {
                InputActionSheet operation = new InputActionSheet();
                // FIXME 当前组件的操作类型只支持底部动作面板（ActionSheet），故先写死
                operation.setType(InputActionSheet.COMPONENT_TYPE);
                operation.setPlaceholder(LocaleUtil.getPhrasedMobileText(locale,
                        LocaleUtil.getMobileTextByKey(locale, "请选择"), selectColumn.getHeaderName(),
                        ""));

                Optional<Rule> optSelectColumnRule = mobileRuleList.stream().filter(
                        rule -> rule.getSchema().equalsIgnoreCase(selectColumn.getSchema())
                                && rule.getCategory()
                                .equalsIgnoreCase(RuleCategoryEnum.VALIDATE.getCategory()) && rule.getType()
                                .equalsIgnoreCase(ValidateRuleTypeEnum.REQUIRED.getType())).findFirst();
                if (optSelectColumnRule.isPresent()) {
                    operation.setRequired(true);
                    operation.setErrorMessage(LocaleUtil.getPhrasedMobileText(locale,
                            LocaleUtil.getMobileTextByDatabaseKey(locale,
                                    optSelectColumnRule.get().getErrorMsgPrefix()),
                            selectColumn.getHeaderName(), ""));
                } else {
                    operation.setRequired(false);
                }
                operation.setTitle(selectColumn.getHeaderName());
                operation.setSchema(selectColumn.getSchema());

                List<InputWindowSingleSelect> nextOperations = new ArrayList<>();
                // FIXME 测试代码
                for (UiBotTableColumn column : openWindowColumnList) {
                    JSONObject uibotTableColumnOperation = column.getOperations().getJSONObject(0);
                    String operateName = uibotTableColumnOperation.getString("operate");
                    if ("openwindow".equalsIgnoreCase(operateName)) {
                        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
                        boolean required = mobileRuleList.stream().filter(
                                        rule -> rule.getSchema().equalsIgnoreCase(column.getSchema())
                                                && rule.getCategory()
                                                .equalsIgnoreCase(RuleCategoryEnum.VALIDATE.getCategory())
                                                && rule.getType()
                                                .equalsIgnoreCase(ValidateRuleTypeEnum.REQUIRED.getType()))
                                .findFirst().isPresent();
                        windowSingleSelect.setRequired(required);
                        windowSingleSelect.setTitle(column.getHeaderName());
                        windowSingleSelect.setSchema(column.getSchema());
                        windowSingleSelect.setUrl(
                                AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list");
                        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_GREY.getValue());

                        Map<String, Object> windowSingleSelectRawData = new HashMap<>();
                        windowSingleSelectRawData.put("dataSourceSet",
                                uibotTableColumnOperation.getJSONObject("openWindowDefine")
                                        .getJSONObject("allAction").getJSONObject("dataSourceSet"));
                        windowSingleSelectRawData.put("defaultShow",
                                uibotTableColumnOperation.getJSONObject("openWindowDefine")
                                        .getJSONObject("allAction").getBooleanValue("defaultShow"));
                        windowSingleSelectRawData.put("executeContext",
                                uibotTableColumnOperation.getJSONObject("openWindowDefine")
                                        .getJSONObject("allAction").getJSONObject("executeContext"));
                        windowSingleSelectRawData.put("multipleSelect",
                                uibotTableColumnOperation.getJSONObject("openWindowDefine")
                                        .getBooleanValue("multipleSelect"));
                        windowSingleSelectRawData.put("selectedFirstRow",
                                uibotTableColumnOperation.getJSONObject("openWindowDefine")
                                        .getBooleanValue("selectedFirstRow"));
                        windowSingleSelectRawData.put("queryTagSuffix", "DIALOG");
                        windowSingleSelectRawData.put("parameter", groupedBizData);
                        windowSingleSelect.setRawData(windowSingleSelectRawData);

                        nextOperations.add(windowSingleSelect);
                    }
                }

                List<InputActionSheet.Option> operationOptionList = new ArrayList<>();
                selectColumn.getEditor().getOptions().forEach(o -> {
                    InputActionSheet.Option tempOption = new InputActionSheet.Option();
                    // FIXME 需要根据不同任务进行不同逻辑判断，目前先以支持工单处理方案任务为主
                    if (EcnWoChangeExceptionRuleLogic.isHandleModeValid(groupedBizData,
                            (String) o.getValue())) {
                        tempOption.setName(o.getTitle());
                        tempOption.setId(String.valueOf(o.getValue()));

                        tempOption.setDisabled(false);
                        // FIXME 20210819 设计变更应用的方案处理任务写死的，需要结合后续动态的界面修改
                        if ("C".equals(o.getValue())) {
                            tempOption.setNextOperations(nextOperations);
                        }
                        operationOptionList.add(tempOption);
                    }
                });
                operation.setOptions(operationOptionList);

                bizProcessSubDataItem.setOperation(operation);
            }

            // TODO 没有任务tag的字段，使用普通的Field


            if (Objects.nonNull(bizProcessDataListLayout.getMItemActionType())) {
                Integer mItemActionType = bizProcessDataListLayout.getMItemActionType();
                bizProcessSubDataItem.setItemActionType(mItemActionType);
                if (Objects.nonNull(bizProcessDataListLayout.getMItemButtonLayoutModel())
                        && BizProcessDataItemActionTypeEnum.BUTTON_ONLY.getValue()
                        .equals(mItemActionType)) {
                    bizProcessSubDataItem.setButtonLayout(
                            BizProcessSubDataItem.handleButtonLayoutModel(apiRequest,
                                    bizProcessDataListLayout.getMItemButtonLayoutModel(), pcUiBotModel,
                                    groupedBizData));
                }
            }
            if (Objects.nonNull(bizProcessDataListLayout.getMItemActionErrorMessage())) {
                bizProcessSubDataItem.setErrorMessage(LocaleUtil.getMobileTextByDatabaseKey(locale,
                        bizProcessDataListLayout.getMItemActionErrorMessage()));
            }

            if (null != businessLogicHandler) {
                businessLogicHandler.handleLogic(bizProcessSubDataItem, groupedBizData, null);
            }

            generatedResult.add(bizProcessSubDataItem);
        }

        return generatedResult;

    }

    /**
     * 当没有字段有“对象标题”这个tag时，从所有字段中按顺序获取第一对xxx_name,xxx_no的字段对，作为对象标题字段返回
     *
     * @param allColumns 所有字段
     * @return 第一对叫xxx_name，xxx_no的字段对
     * @Deprecated on 20211228 前端已经做了防呆，不会报错，故可以不再使用；
     * 若后续发现标题空白，首先检查数据库中是否配置了DISPLAY_TITLE的tag
     */
    @Deprecated
    private static List<UiBotTableColumn> getSubjectTitleColumns(
            List<UiBotTableColumn> allColumns) {
        List<UiBotTableColumn> result = new ArrayList<>();
        String columnPrefixFieldName = null;
        for (UiBotTableColumn column : allColumns) {
            if (null == column.getSchema()) {
                /**
                 * 2021年8月17日
                 * 如果没有schema，发现是type=DIFFERENCE_CALCULATION的栏位，它会将两个值做比较进行展示。
                 * 所以不可能是对象的标题字段，故可直接跳过
                 */
                continue;
            }
            if (column.getSchema().toLowerCase().endsWith("_name") || column.getSchema()
                    .toLowerCase().endsWith("_no")) {
                if (null == columnPrefixFieldName) {
                    int lastIndex = column.getSchema().lastIndexOf("_");
                    columnPrefixFieldName = column.getSchema().substring(0, lastIndex);

                    result.add(column);
                } else {
                    if (column.getSchema().toLowerCase().startsWith(columnPrefixFieldName)) {
                        result.add(column);
                    }
                }
            }
            if (result.size() == 2) {
                break;
            }
        }
        return result;
    }

    private static UiBotModel handleButtonLayoutModel(ApiRequest apiRequest,
                                                      final UiBotModel buttonLayoutModel, UiBotModel pcUiBotModel,
                                                      Map<String, Object> groupedBizData) {
        String locale = apiRequest.getLocale();
        UiBotModel resultUiBotModel = UiBotModel.emptyUiBotModel();
        for (UiBotLayout layout : buttonLayoutModel.getLayout()) {
            if (BottomButtonDigiwinAthena.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                String schema = layout.getSchema();
                BottomButtonList bottomButtonList =
                        JsonUtil.objectToJavaObject(buttonLayoutModel.getPageData().get(schema),
                                BottomButtonList.class);
                if (bottomButtonList != null) {
                    bottomButtonList.forEach(bottomButton -> {
                        bottomButton.setName(
                                LocaleUtil.getMobileTextByDatabaseKey(locale, bottomButton.getName()));
                        bottomButton.setActionDoneName(LocaleUtil.getMobileTextByDatabaseKey(locale,
                                bottomButton.getActionDoneName()));
                        // 处理按钮的定制配置
                        bottomButton.handleButtonCustomConfig(apiRequest, pcUiBotModel,
                                groupedBizData);
                    });
                }
                resultUiBotModel.getLayout().add(layout);
                resultUiBotModel.getPageData().put(schema, bottomButtonList);
            } else {
                continue;
            }
        }

        return resultUiBotModel;
    }

    @Override
    public String returnComponentType() {
        return BizProcessSubDataItem.COMPONENT_TYPE;
    }

    public void addComparisonFieldToSummaryList(List<ComparisonField> summaryList) {
        if (null != this.getSummaryList()) {
            this.getSummaryList().addAll(summaryList);
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<? super ComparisonField> getSummaryList() {
        if (null == this.summaryList) {
            this.summaryList = new ArrayList<>();
        }
        return this.summaryList;
    }

    public void setSummaryList(List<? super ComparisonField> summaryList) {
        this.summaryList = summaryList;
    }

    public List<ComparisonField> getComparedData() {
        if (null == comparedData) {
            comparedData = new ArrayList<>();
        }
        return comparedData;
    }

    public void setComparedData(List<ComparisonField> comparedData) {
        this.comparedData = comparedData;
    }

    public InputActionSheet getOperation() {
        return operation;
    }

    public void setOperation(InputActionSheet operation) {
        this.operation = operation;
    }

    public UiBotModel getButtonLayout() {
        return buttonLayout;
    }

    public void setButtonLayout(UiBotModel buttonLayout) {
        this.buttonLayout = buttonLayout;
    }

    public Integer getItemActionType() {
        return itemActionType;
    }

    public void setItemActionType(Integer itemActionType) {
        this.itemActionType = itemActionType;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public BizProcessSubDataItemOperateData getOperateData() {
        return operateData;
    }

    public void setOperateData(BizProcessSubDataItemOperateData operateData) {
        this.operateData = operateData;
    }
}
