package com.digiwin.mobile.mobileuibot.core.component.business.pcc;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PccStringUtil
 * @Author: Zaregoto
 * @Date: 2022/5/23 1:59
 */
@Component
public final class PccStringUtil {

    private static final Map<String, String> ordAndReviewCategoryValueTextMap = new HashMap<>();
    private static final Map<String, String> plmCategoryValueTextMap = new HashMap<>();
    private static final Map<String, String> plmProjectCategoryValueTextMap = new HashMap<>();
    private static final Map<String, String> mesCategoryValueTextMap = new HashMap<>();
    private static final Map<String, String> posumCategoryValueTextMap = new HashMap<>();
    private static final Map<String, String> otherCategoryValueTextMap = new HashMap<>();

    {
        // 依不同任务类型，初始化必要的展示文字，后续使用LocaleUtil即可转换
        ordAndReviewCategoryValueTextMap.put("task_status_10", "未开始");
        ordAndReviewCategoryValueTextMap.put("task_status_20", "进行中");
        ordAndReviewCategoryValueTextMap.put("task_status_30", "已完成");
        ordAndReviewCategoryValueTextMap.put("task_status_40", "指定完成");
        ordAndReviewCategoryValueTextMap.put("task_status_50", "暂停");
        ordAndReviewCategoryValueTextMap.put("task_status_60", "签核中");
        ordAndReviewCategoryValueTextMap.put("task_tag_1", "前置任务未完成");
        ordAndReviewCategoryValueTextMap.put("task_tag_2", "前置任务提前完成");
        ordAndReviewCategoryValueTextMap.put("task_tag_3", "无");
        ordAndReviewCategoryValueTextMap.put("task_tag_4", "项目暂停");
        ordAndReviewCategoryValueTextMap.put("is_approve_true", "需签核");
        ordAndReviewCategoryValueTextMap.put("is_approve_false", "无需签核");
        ordAndReviewCategoryValueTextMap.put("is_attachment_true", "有交付物");
        ordAndReviewCategoryValueTextMap.put("is_attachment_false", "无交付物");
        ordAndReviewCategoryValueTextMap.put("project_status_10", "潜在");
        ordAndReviewCategoryValueTextMap.put("project_status_20", "正式");
        ordAndReviewCategoryValueTextMap.put("project_status_30", "进行中");
        ordAndReviewCategoryValueTextMap.put("project_status_40", "已结案");
        ordAndReviewCategoryValueTextMap.put("project_status_50", "暂停");
        ordAndReviewCategoryValueTextMap.put("project_status_60", "指定结案");
        ordAndReviewCategoryValueTextMap.put("closed_stus_true", "是");
        ordAndReviewCategoryValueTextMap.put("closed_stus_false", "否");
        ordAndReviewCategoryValueTextMap.put("required_task_true", "是");
        ordAndReviewCategoryValueTextMap.put("required_task_false", "否");

        plmCategoryValueTextMap.put("", "");

        plmProjectCategoryValueTextMap.put("task_status_30", "进行中");
        plmProjectCategoryValueTextMap.put("task_status_40", "已结案");
        plmProjectCategoryValueTextMap.put("task_status_50", "暂停");
        plmProjectCategoryValueTextMap.put("task_status_60", "指定结案");

        mesCategoryValueTextMap.put("status_0", "未确认");
        mesCategoryValueTextMap.put("status_1", "确认中");
        mesCategoryValueTextMap.put("status_2", "已确认");
        mesCategoryValueTextMap.put("status_3", "允许开立生产批");
        mesCategoryValueTextMap.put("status_6", "退货仓的工单");
        mesCategoryValueTextMap.put("status_99", "工单结案");
        mesCategoryValueTextMap.put("op_type_1", "厂内制程");
        mesCategoryValueTextMap.put("op_type_2", "委外制程");

        otherCategoryValueTextMap.put("status_1", "未生产");
        otherCategoryValueTextMap.put("status_2", "已发料");
        otherCategoryValueTextMap.put("status_3", "生产中");
        otherCategoryValueTextMap.put("status_Y", "已完工");
        otherCategoryValueTextMap.put("status_y", "指定完工");
        otherCategoryValueTextMap.put("status_N", "未完工");
        otherCategoryValueTextMap.put("op_type_1", "厂内制程");
        otherCategoryValueTextMap.put("op_type_2", "托外制程");
        otherCategoryValueTextMap.put("op_type_3", "二者皆有");
        otherCategoryValueTextMap.put("close_status_N", "未结案");
        otherCategoryValueTextMap.put("close_status_Y", "自动结案");
        otherCategoryValueTextMap.put("close_status_y", "指定结案");
        otherCategoryValueTextMap.put("close_status_0", "未结束");
        otherCategoryValueTextMap.put("close_status_1", "指定结束");
        otherCategoryValueTextMap.put("close_status_2", "已结束");
    }

    /**
     * 各个任务类型的尾阶任务详情的条目详情使用的所有字段
     */
    private static final String[] ordAndReviewCategoryTailTaskDetailItemDetailFieldArray = new String[]{
            "liable_person_name",
            "plan_start_date", "plan_finish_date", "actual_start_date", "remarks", "work_hours", "complete_rate",
            "actual_finish_date", "total_work_hours", "attachment_remark", "remark", "is_approve", "attachment"
    };
    private static final String[] plmCategoryTailTaskDetailItemDetailFieldArray = new String[]{
            "design_status",
            "project_no", "task_no", "complete_rate", "remark", "design_no", "design_name",
            "report_work_description", "actual_start_date", "actual_finish_date",
    };
    private static final String[] plmProjectCategoryTailTaskDetailItemDetailFieldArray = new String[]{
            "task_status",
            "task_name", "task_complete_rate", "is_on_schedule", "important",
            "actual_start_date", "actual_finish_date", "project_no", "task_no", "task_seq", "upper_level_task_no",
            "before_task_no", "milestone_type", "plan_work_days", "plan_work_hours", "plan_start_date",
            "plan_finish_date", "executor_name", "executor_role",
    };
    private static final String[] mesCategoryTailTaskDetailItemDetailFieldArray = new String[]{
            "status",
            "wo_no", "item_no", "item_name_spec", "machine_no", "production_qty", "plan_date_e", "complete_rate",
            "work_hours", "process_seq", "op_name", "op_type", "supplier_name", "feed_qty", "complete_qty", "op_no"
    };
    private static final String[] posumCategoryTailTaskDetailItemDetailFieldArray = new String[]{
            "purchase_no",
            "reference_type_no", "reference_doc_no", "item_name_spec", "item_classification", "complete_rate", "purchaser_name",
            "purchase_qty", "stock_in_qty"
    };
    private static final String[] otherCategoryTailTaskDetailItemDetailFieldArray = new String[]{
            "item_no",
            "item_name_spec_02", "purchaser_name", "purchase_no", "purchase_qty", "status", "purchase_seq",
            "purchase_sub_seq", "stock_in_qty", "issue_set_qty", "plan_delivery_date", "complete_rate"
    };

    private static final String[] otherCategoryKscTailTaskDetailItemDetailFieldArray = new String[]{
            "status",
            "purchaser_name", "purchase_no", "purchase_seq", "purchase_sub_seq", "item_no", "item_name_spec",
            "purchase_qty", "stock_in_qty", "issue_set_qty", "plan_delivery_date", "complete_rate"
    };

    /**
     * 根据已有的map，针对应用API返回的字段值，做展示文字的处理。
     * 如果字段值在map中存在的，表示需要做处理（比如api返回了字符串“1”，文字要展示“已完成”）；
     * 如果字段值在map中不存在的，则表示不需要做处理，直接返回
     *
     * @param locale       语言别
     * @param taskCategory PCC任务类型
     * @param field        API返回的字段
     * @param value        API返回的字段值
     * @return 字段值的展示文字
     */
    public static String getValueShowText(String locale, String taskCategory, String field, String value) {
        Assert.notNull(taskCategory, "taskCategory must not null!");
        if (field.toLowerCase().contains("rate")) {
            Number numberValue = Double.parseDouble(value);
            double dValue = numberValue.doubleValue();
            value = String.format("%.0f%%", dValue * 100.0);
        }
        String showText;
        switch (taskCategory.toUpperCase()) {
            case "ORD":
            case "REVIEW":
            case "1": //试验北斗-产品设计和开发
            case "2": //试验北斗-过程设计和开发
            case "3": //试验北斗-产品与过程确认
            case "4": //试验优测-试验检测
                showText = ordAndReviewCategoryValueTextMap.getOrDefault(field + "_" + value, value);
                break;
            case "PLM":
                showText = plmCategoryValueTextMap.getOrDefault(field + "_" + value, value);
                break;
            case "PLM_PROJECT":
                showText = plmProjectCategoryValueTextMap.getOrDefault(field + "_" + value, value);
                break;
            case "MES":
                showText = mesCategoryValueTextMap.getOrDefault(field + "_" + value, value);
                break;
            case "POSUM":
                showText = posumCategoryValueTextMap.getOrDefault(field + "_" + value, value);
                break;
            default:
                showText = otherCategoryValueTextMap.getOrDefault(field + "_" + value, value);
                break;
        }
        return showText;
    }

    /**
     * 根据任务类型获取所需要的字段清单
     *
     * @param taskCategory
     * @return
     */
    public static String[] getFieldsByTaskCategory(String taskCategory, boolean isKsc) {
        Assert.notNull(taskCategory, "taskCategory must not null!");
        String[] fieldsArray = null;
        switch (taskCategory) {
            case "ORD":
            case "REVIEW":
            case "1": //试验北斗-产品设计和开发
            case "2": //试验北斗-过程设计和开发
            case "3": //试验北斗-产品与过程确认
            case "4": //试验优测-试验检测
                fieldsArray = ordAndReviewCategoryTailTaskDetailItemDetailFieldArray;
                break;
            case "PLM":
                fieldsArray = plmCategoryTailTaskDetailItemDetailFieldArray;
                break;
            case "PLM_PROJECT":
                fieldsArray = plmProjectCategoryTailTaskDetailItemDetailFieldArray;
                break;
            case "MES":
                fieldsArray = mesCategoryTailTaskDetailItemDetailFieldArray;
                break;
            case "POSUM":
                fieldsArray = posumCategoryTailTaskDetailItemDetailFieldArray;
                break;
            default:
                // 只针对项目中控台，体系云管家保持原样
                if (isKsc) {
                    fieldsArray = otherCategoryKscTailTaskDetailItemDetailFieldArray;
                } else {
                    fieldsArray = otherCategoryTailTaskDetailItemDetailFieldArray;
                }
                break;
        }
        return fieldsArray;
    }
}
