package com.digiwin.mobile.mobileuibot.core.component.business.pcc;

import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignEnum;
import com.digiwin.mobile.mobileuibot.core.component.business.DetailPage;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：尾阶任务详情条目对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PccTailTaskProductItemDataItem
 * @Author: Liux
 * @Date: 2022年5月17日 19点31分
 */
public class PccTailTaskProductItemDataItem implements Serializable {

    private static final long serialVersionUID = 7500260871654689688L;
    public static final String COMPONENT_TYPE = "PCC_TAIL_TASK_PRODUCT_ITEM_DATA_ITEM";

    private static String[] taskCategoryArray = new String[]{"ORD", "PLM", "PLM_PROJECT", "MES,REVIEW", "POSUM", "1", "2", "3", "4"};

    /**
     * 概要字段
     */
    private List<Field> content = new ArrayList<>(5);

    private DetailPage detailPage;

    private Integer openType;

    /**
     * 标题字段+重要字段
     */
    private PccTailTaskProductItemDataItemTitle title;

    private PccTailTaskProductItemDataItem() {
    }

    /**
     * 创建PCC尾阶任务物料条目组件的方法
     *
     * @param apiRequest
     * @param pccTailData
     * @param taskInfo
     * @return
     */
    public static PccTailTaskProductItemDataItem create(ApiRequest apiRequest, Map<String, Object> pccTailData,
                                                        PccProjectTaskInfo taskInfo, String taskCategory) {
        String locale = apiRequest.getLocale();
        String dataId = apiRequest.getDataId();

        PccTailTaskProductItemDataItem dataItem;

        ApiExtraParameter newApiExtraParameter = new ApiExtraParameter();
        newApiExtraParameter.setForItemDetail(true);
        ApiRawData newApiRawData = new ApiRawData();
        // 放入下一级PCC物料详情要的数据，在UiBotModelBuildPccMaterialStrategy类初始化时会使用
        newApiRawData.put("taskInfo", taskInfo);
        newApiRawData.put("productItem", pccTailData);

        switch (taskCategory.toUpperCase()) {
            case "ORD":
                dataItem = PccTailTaskProductItemDataItem.createOrdCategoryItem(apiRequest, pccTailData, taskInfo);
                break;
            case "PLM":
                dataItem = PccTailTaskProductItemDataItem.createPlmCategoryItem(apiRequest, pccTailData, taskInfo);
                break;
            case "PLM_PROJECT":
                dataItem = PccTailTaskProductItemDataItem.createPlmProjectCategoryItem(apiRequest, pccTailData, taskInfo);
                break;
            case "MES":
                dataItem = PccTailTaskProductItemDataItem.createMesCategoryItem(apiRequest, pccTailData, taskInfo);
                break;
            case "REVIEW":
                dataItem = PccTailTaskProductItemDataItem.createReviewCategoryItem(apiRequest, pccTailData, taskInfo);
                break;
            case "POSUM":
                dataItem = PccTailTaskProductItemDataItem.createPosumCategoryItem(apiRequest, pccTailData, taskInfo);
                break;
            default:
                dataItem = PccTailTaskProductItemDataItem.createOtherCategoryItem(apiRequest, pccTailData, taskInfo,false);
                break;
        }
        //先临时给个魔法值
        dataItem.setOpenType(1);
        dataItem.setDetailPage(DetailPage.create(locale,
                dataId,
                newApiExtraParameter,
                PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_MATERIAL_DETAIL.toString(), newApiRawData));

//        Map<String, Object> docInfoMap = new HashMap<>();
//        for (String key : pccTailData.keySet()) {
//            if ("MES".equalsIgnoreCase(taskCategory) && "status".equalsIgnoreCase(key)) {
//                key = "close_status";
//            }
//            String[] docInfoMapArr = {"close_status", "purchase_no", "purchase_seq", "item_no", "item_name_spec"};
//            if (MobileUiBotStringUtil.isHaveThisString(docInfoMapArr, key)) {
//                docInfoMap.put(key, pccTailData.get(key));
//            } else {
//                continue;
//            }
//        }
//
//        List<String> leftTitle = new ArrayList<>();
//        List<String> rightTitle = new ArrayList<>();
//        PccTailTaskProductItemDataItem dataItem = new PccTailTaskProductItemDataItem();
//        String[] titles;
//        if ("MES".equalsIgnoreCase(taskInfo.getTaskCategory())) {
//            titles = new String[]{"status"};
//        } else {
//            titles = new String[]{"close_status"};
//        }
//
//        for (String key : docInfoMap.keySet()) {
//            //title
//            if (MobileUiBotStringUtil.isHaveThisString(titles, key)) {
//                String closeStatus = (String) docInfoMap.get(key);
//                leftTitle.add(closeStatusName(closeStatus));
//                //因为这个参数作为了标题了，后面不需要赋值了。
//                continue;
//            }
//            Field itemContentField = Field.create(LocaleUtil.getMobileTextByKey(locale, key), 2, 1, String.valueOf(docInfoMap.get(key)));
//            itemContentField.setSchema(key);
//            // 只读的话，空值，移动不显示
//            if (!itemContentField.getValue().trim().isEmpty()) {
//                dataItem.getContent().add(itemContentField);
//            }
//
//        }
//        dataItem.setTitle(PccTailTaskProductItemDataItemTitle.create(
//                locale, leftTitle, rightTitle.isEmpty() ? "" : rightTitle.get(0)));
        // 所有字段都在detailPage加载的时候处理。
       /* "extraParameter": {
            "tmActivityId": "purchaseApproval_PWD",
                    "tmCategory": "APPROVAL",
                    "tmPattern": "BUSINESS",
                    "tmTaskId": "task_Send_PO"
        },*/
        /*ApiExtraParameter newApiExtraParameter = new ApiExtraParameter();
        newApiExtraParameter.setForItemDetail(true);
        ApiRawData newApiRawData = new ApiRawData();
        // 放入下一级PCC物料详情要的数据，在UiBotModelBuildPccMaterialStrategy类初始化时会使用
        newApiRawData.put("taskInfo", taskInfo);
        newApiRawData.put("productItem", pccTailData);*/

        //先临时给个魔法值
        /*dataItem.setOpenType(1);
        dataItem.setDetailPage(DetailPage.create(locale,
                dataId,
                newApiExtraParameter,
                PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_MATERIAL_DETAIL.toString(), newApiRawData));*/


        return dataItem;
    }

    /**
     * 创建KSC尾阶任务物料条目组件的方法
     *
     * @param apiRequest
     * @param pccTailData
     * @param taskInfo
     * @return
     */
    public static PccTailTaskProductItemDataItem createKsc(ApiRequest apiRequest, Map<String, Object> pccTailData,
                                                           PccProjectTaskInfo taskInfo, String taskCategory) {
        String locale = apiRequest.getLocale();
        String dataId = apiRequest.getDataId();

        PccTailTaskProductItemDataItem dataItem;

        ApiExtraParameter newApiExtraParameter = new ApiExtraParameter();
        newApiExtraParameter.setForItemDetail(true);
        ApiRawData newApiRawData = new ApiRawData();
        // 放入下一级PCC物料详情要的数据，在UiBotModelBuildPccMaterialStrategy类初始化时会使用
        newApiRawData.put("taskInfo", taskInfo);
        newApiRawData.put("productItem", pccTailData);

        switch (taskCategory.toUpperCase()) {
            case "ORD":
            case "1": //试验北斗-产品设计和开发
            case "2": //试验北斗-过程设计和开发
            case "3": //试验北斗-产品与过程确认
            case "4": //试验优测-试验检测
                dataItem = PccTailTaskProductItemDataItem.createOrdCategoryItem(apiRequest, pccTailData, taskInfo);
                break;
            case "PLM":
                dataItem = PccTailTaskProductItemDataItem.createPlmCategoryItem(apiRequest, pccTailData, taskInfo);
                break;
            case "PLM_PROJECT":
                dataItem = PccTailTaskProductItemDataItem.createPlmProjectCategoryItem(apiRequest, pccTailData, taskInfo);
                break;
            case "MES":
                dataItem = PccTailTaskProductItemDataItem.createMesCategoryItem(apiRequest, pccTailData, taskInfo);
                break;
            case "REVIEW":
                dataItem = PccTailTaskProductItemDataItem.createReviewCategoryItem(apiRequest, pccTailData, taskInfo);
                break;
            case "POSUM":
                dataItem = PccTailTaskProductItemDataItem.createPosumCategoryItem(apiRequest, pccTailData, taskInfo);
                break;
            default:
                dataItem = PccTailTaskProductItemDataItem.createOtherCategoryItem(apiRequest, pccTailData, taskInfo, true);
                break;
        }
        //先临时给个魔法值
        dataItem.setOpenType(1);
        dataItem.setDetailPage(DetailPage.create(locale,
                dataId,
                newApiExtraParameter,
                PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_MATERIAL_DETAIL.toString(), newApiRawData));

//        Map<String, Object> docInfoMap = new HashMap<>();
//        for (String key : pccTailData.keySet()) {
//            if ("MES".equalsIgnoreCase(taskCategory) && "status".equalsIgnoreCase(key)) {
//                key = "close_status";
//            }
//            String[] docInfoMapArr = {"close_status", "purchase_no", "purchase_seq", "item_no", "item_name_spec"};
//            if (MobileUiBotStringUtil.isHaveThisString(docInfoMapArr, key)) {
//                docInfoMap.put(key, pccTailData.get(key));
//            } else {
//                continue;
//            }
//        }
//
//        List<String> leftTitle = new ArrayList<>();
//        List<String> rightTitle = new ArrayList<>();
//        PccTailTaskProductItemDataItem dataItem = new PccTailTaskProductItemDataItem();
//        String[] titles;
//        if ("MES".equalsIgnoreCase(taskInfo.getTaskCategory())) {
//            titles = new String[]{"status"};
//        } else {
//            titles = new String[]{"close_status"};
//        }
//
//        for (String key : docInfoMap.keySet()) {
//            //title
//            if (MobileUiBotStringUtil.isHaveThisString(titles, key)) {
//                String closeStatus = (String) docInfoMap.get(key);
//                leftTitle.add(closeStatusName(closeStatus));
//                //因为这个参数作为了标题了，后面不需要赋值了。
//                continue;
//            }
//            Field itemContentField = Field.create(LocaleUtil.getMobileTextByKey(locale, key), 2, 1, String.valueOf(docInfoMap.get(key)));
//            itemContentField.setSchema(key);
//            // 只读的话，空值，移动不显示
//            if (!itemContentField.getValue().trim().isEmpty()) {
//                dataItem.getContent().add(itemContentField);
//            }
//
//        }
//        dataItem.setTitle(PccTailTaskProductItemDataItemTitle.create(
//                locale, leftTitle, rightTitle.isEmpty() ? "" : rightTitle.get(0)));
        // 所有字段都在detailPage加载的时候处理。
       /* "extraParameter": {
            "tmActivityId": "purchaseApproval_PWD",
                    "tmCategory": "APPROVAL",
                    "tmPattern": "BUSINESS",
                    "tmTaskId": "task_Send_PO"
        },*/
        /*ApiExtraParameter newApiExtraParameter = new ApiExtraParameter();
        newApiExtraParameter.setForItemDetail(true);
        ApiRawData newApiRawData = new ApiRawData();
        // 放入下一级PCC物料详情要的数据，在UiBotModelBuildPccMaterialStrategy类初始化时会使用
        newApiRawData.put("taskInfo", taskInfo);
        newApiRawData.put("productItem", pccTailData);*/

        //先临时给个魔法值
        /*dataItem.setOpenType(1);
        dataItem.setDetailPage(DetailPage.create(locale,
                dataId,
                newApiExtraParameter,
                PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_MATERIAL_DETAIL.toString(), newApiRawData));*/


        return dataItem;
    }

    private static PccTailTaskProductItemDataItem createOrdCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData,
                                                                        PccProjectTaskInfo taskInfo) {
        String[] leftTitleFields = new String[]{"liable_person_name"};
        String rightTitleField = "";
        String[] contentFields = new String[]{
                "plan_start_date", "plan_finish_date", "actual_start_date", "remarks", "work_hours", "complete_rate",
                "actual_finish_date", "total_work_hours", "attachment_remark", "remark", "is_approve", "attachment"
        };

        final int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem(apiRequest.getLocale(), taskInfo, pccTailData,
                leftTitleFields, rightTitleField, contentFields, contentFieldsLimit);
    }

    private static PccTailTaskProductItemDataItem createPlmCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData,
                                                                        PccProjectTaskInfo taskInfo) {
        String[] leftTitleFields = new String[]{"design_status"};
        String rightTitleField = "";
        // FIXME 因pc端没数据，无法知道展示字段的顺序如何，故根据api返回值将所有字段放入，并按移动的理解排序。后续找到数据后，再看需求改顺序
        String[] contentFields = new String[]{
                "project_no", "task_no", "complete_rate", "remark", "design_no", "design_name",
                "report_work_description", "actual_start_date", "actual_finish_date",
        };

        final int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem(apiRequest.getLocale(), taskInfo, pccTailData,
                leftTitleFields, rightTitleField, contentFields, contentFieldsLimit);
    }

    private static PccTailTaskProductItemDataItem createPlmProjectCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData,
                                                                               PccProjectTaskInfo taskInfo) {
        String[] leftTitleFields = new String[]{"task_status"};
        String rightTitleField = "";
        // FIXME 因pc端没数据，无法知道展示字段的顺序如何，故根据api返回值将所有字段放入，并按移动的理解排序。后续找到数据后，再看需求改顺序
        String[] contentFields = new String[]{
                "task_name", "task_complete_rate", "is_on_schedule", "important",
                "actual_start_date", "actual_finish_date", "project_no", "task_no", "task_seq", "upper_level_task_no",
                "before_task_no", "milestone_type", "plan_work_days", "plan_work_hours", "plan_start_date",
                "plan_finish_date", "executor_name", "executor_role",
        };

        final int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem(apiRequest.getLocale(), taskInfo, pccTailData,
                leftTitleFields, rightTitleField, contentFields, contentFieldsLimit);
    }

    private static PccTailTaskProductItemDataItem createMesCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData,
                                                                        PccProjectTaskInfo taskInfo) {
        String[] leftTitleFields = new String[]{"status"};
        String rightTitleField = "";
        // FIXME 因pc端没数据，无法知道展示字段的顺序如何，故根据api返回值将所有字段放入，并按移动的理解排序。后续找到数据后，再看需求改顺序
        String[] contentFields = new String[]{
                "wo_no", "item_no", "item_name_spec", "machine_no", "production_qty", "plan_date_e", "complete_rate",
                "work_hours", "process_seq", "op_name", "op_type", "supplier_name", "feed_qty", "complete_qty", "op_no"
        };

        final int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem(apiRequest.getLocale(), taskInfo, pccTailData,
                leftTitleFields, rightTitleField, contentFields, contentFieldsLimit);

    }

    private static PccTailTaskProductItemDataItem createReviewCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData,
                                                                           PccProjectTaskInfo taskInfo) {
        String[] leftTitleFields = new String[]{"liable_person_name"};
        String rightTitleField = "";
        String[] contentFields = new String[]{
                "plan_start_date", "plan_finish_date", "actual_start_date", "remarks", "work_hours", "complete_rate",
                "actual_finish_date", "total_work_hours", "attachment_remark", "remark", "is_approve", "attachment"
        };

        final int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem(apiRequest.getLocale(), taskInfo, pccTailData,
                leftTitleFields, rightTitleField, contentFields, contentFieldsLimit);
    }

    private static PccTailTaskProductItemDataItem createPosumCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData,
                                                                          PccProjectTaskInfo taskInfo) {
        String[] leftTitleFields = new String[]{"purchase_no"};
        String rightTitleField = "";
        String[] contentFields = new String[]{
                "reference_type_no", "reference_doc_no", "item_name_spec", "item_classification", "complete_rate", "purchaser_name",
                "purchase_qty", "stock_in_qty"
        };

        final int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem(apiRequest.getLocale(), taskInfo, pccTailData,
                leftTitleFields, rightTitleField, contentFields, contentFieldsLimit);
    }

    private static PccTailTaskProductItemDataItem createOtherCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData,
                                                                          PccProjectTaskInfo taskInfo, boolean isKsc) {
        String[] leftTitleFields = new String[]{"item_no"};
        String rightTitleField = "";

        String[] contentFields;
        if (isKsc) {
            contentFields = new String[]{
                    "purchaser_name", "purchase_no", "purchase_seq", "purchase_sub_seq", "item_no", "item_name_spec",
                    "purchase_qty", "stock_in_qty", "issue_set_qty", "plan_delivery_date", "complete_rate"};
        } else {
            contentFields = new String[]{
                    "item_name_spec_02", "purchaser_name", "purchase_no", "purchase_qty", "status", "purchase_seq",
                    "purchase_sub_seq", "stock_in_qty", "issue_set_qty", "plan_delivery_date", "complete_rate"
            };
        }

        pccTailData.put("isKsc", isKsc);

        final int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem(apiRequest.getLocale(), taskInfo, pccTailData,
                leftTitleFields, rightTitleField, contentFields, contentFieldsLimit);
    }

    /**
     * 通用的基础明细条目生成方法，可通过指定左标题的字段数组、右标题的字段以及概要内容的字段数组，以及概要内容字段上限进行生成
     *
     * @param locale                  语言别
     * @param taskInfo                任务详情
     * @param bizData                 业务数据对象
     * @param leftTitleFields         左标题的字段数组
     * @param rightTitleField         右标题的字段
     * @param contentFields           概要内容的字段数组
     * @param contentFieldCreateLimit 概要内容字段数量生成上限
     * @return 明细条目组件
     */
    private static PccTailTaskProductItemDataItem baseCreateItem(String locale, PccProjectTaskInfo taskInfo,
                                                                 Map<String, Object> bizData, String[] leftTitleFields,
                                                                 String rightTitleField, String[] contentFields,
                                                                 int contentFieldCreateLimit) {
        List<String> leftTitle = new ArrayList<>();
        List<String> rightTitle = new ArrayList<>();
        PccTailTaskProductItemDataItem productItemDataItem = new PccTailTaskProductItemDataItem();
        int contentFieldCreatedCount = 0;

        boolean isNotOtherCategory = Arrays.stream(taskCategoryArray).anyMatch(e->e.equalsIgnoreCase(taskInfo.getTaskCategory()));
        Boolean isKsc = (Boolean) MapUtil.getOrDefault(bizData, "isKsc", false);

        // 标题字段
        for (String leftTitleField : leftTitleFields) {
            String value = String.valueOf(MapUtil.getOrDefault(bizData, leftTitleField, ""));
            if (value.trim().isEmpty()) {
                // 只读的话，空值，移动不显示，故不处理

                // taskCategory 为other 同时只是项目中控台的 才在值为空的时候显示横杠
                if (!isNotOtherCategory && !isKsc) {
                    value = "-";
                } else {
                    continue;
                }
            }
            value = PccStringUtil.getValueShowText(locale, taskInfo.getTaskCategory(), leftTitleField, value);
            leftTitle.add(value);
        }
        if (bizData.containsKey(rightTitleField)) {
            String value = String.valueOf(MapUtil.getOrDefault(bizData, rightTitleField, ""));
            if (!value.trim().isEmpty()) {
                value = PccStringUtil.getValueShowText(locale, taskInfo.getTaskCategory(), rightTitleField, value);
                rightTitle.add(value);
            }
        }
        productItemDataItem.setTitle(PccTailTaskProductItemDataItemTitle.create(
                locale, leftTitle, rightTitle.isEmpty() ? "" : rightTitle.get(0)));

        // 概要字段
        for (String contentField : contentFields) {
            String label = LocaleUtil.getMobileTextByKey(locale, contentField);
            String value = String.valueOf(MapUtil.getOrDefault(bizData, contentField, ""));

            // 品名规格，使用item_name_spec_02 ，包含了品名和规格，中间web端用</br>来换行将规格展示在品名下面，移动需要替换为\n
            if ("item_name_spec_02".equals(contentField) && !isNotOtherCategory && !isKsc){
                value = value.replace("</br>", "\n");
                label = LocaleUtil.getMobileTextByKey(locale, "item_name_spec");
            }
            if (value.trim().isEmpty() || "attachment".equals(contentField)) {
                // 只读的话，空值，移动不显示，故不处理
                // 附件字段也不处理，因不适合展示在列表的卡片中。
                if (!isNotOtherCategory) {
                    value = "-";
                } else {
                    continue;
                }
            }
            value = PccStringUtil.getValueShowText(locale, taskInfo.getTaskCategory(), contentField, value);

            Field itemContentField = Field.create(label, 2, 1, value);
            itemContentField.setSchema(contentField);

            // 报工说明换行样式调整
            if ("remarks".equalsIgnoreCase(contentField) && value.contains("\n")) {
                value = value.replaceAll("\n", "\n● ");
                value = "● " + value;
                itemContentField.setValue(value);
                itemContentField.setAlign(FieldAlignEnum.VERTICAL.getValue());
            }

            productItemDataItem.getContent().add(itemContentField);
            contentFieldCreatedCount++;
            if (contentFieldCreatedCount == contentFieldCreateLimit) {
                break;
            }
        }
        return productItemDataItem;
    }

    public List<Field> getContent() {
        return content;
    }

    public void setContent(List<Field> content) {
        this.content = content;
    }

    public DetailPage getDetailPage() {
        return detailPage;
    }

    public void setDetailPage(DetailPage detailPage) {
        this.detailPage = detailPage;
    }

    public PccTailTaskProductItemDataItemTitle getTitle() {
        return title;
    }

    public void setTitle(PccTailTaskProductItemDataItemTitle title) {
        this.title = title;
    }

    public Integer getOpenType() {
        return openType;
    }

    public void setOpenType(Integer openType) {
        this.openType = openType;
    }
}
