package com.digiwin.mobile.mobileuibot.core.component.business.pcc;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import org.springframework.util.Assert;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：尾阶任务详情条目的对象的标题对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PccTailTaskProductItemDataItemTitle
 * @Author: Liux
 * @Date: 2022年5月17日 19点31分
 */
public class PccTailTaskProductItemDataItemTitle extends BaseMobileComponent implements Serializable {

    private static final long serialVersionUID = -4465741909556782008L;
    public static final String COMPONENT_TYPE = "PCC_TAIL_TASK_PRODUCT_ITEM_DATA_ITEM";

    private List<String> leftTitle;
    private String rightTitle;

    public PccTailTaskProductItemDataItemTitle() {
    }

    public static PccTailTaskProductItemDataItemTitle create(String locale, List<String> leftTitle, String rightTitle) {
        Assert.notNull(leftTitle, "lefttitle in dataitem cannot be null");
        PccTailTaskProductItemDataItemTitle title = new PccTailTaskProductItemDataItemTitle();
        if (leftTitle.size() > 3) {
            title.setLeftTitle(leftTitle.subList(0, 3));
        } else {
            title.setLeftTitle(leftTitle);
        }
        title.setRightTitle(rightTitle);

        return title;
    }

    public List<String> getLeftTitle() {
        return leftTitle;
    }

    public void setLeftTitle(List<String> leftTitle) {
        this.leftTitle = leftTitle;
    }

    public String getRightTitle() {
        return rightTitle;
    }

    public void setRightTitle(String rightTitle) {
        this.rightTitle = rightTitle;
    }

    public void addToLeftTitle(String otherTitle) {
        this.leftTitle.add(otherTitle);
    }

    @Override public String returnComponentType() {
        return PccTailTaskProductItemDataItemTitle.COMPONENT_TYPE;
    }
}
