package com.digiwin.mobile.mobileuibot.core.component.business.pcc;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BaseTab;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：尾阶任务详情Tab对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PccTailTaskProductItemTab
 * @Author: Liux
 * @Date: 2022年5月17日 19点31分
 */
public class PccTailTaskProductItemTab extends BaseTab<PccTailTaskProductItemDataList> implements MobileComponent, Serializable {

    private static final long serialVersionUID = 3857166003299449572L;
    public static final String COMPONENT_TYPE = "PCC_TAIL_TASK_PRODUCT_ITEM_TAB";

    public PccTailTaskProductItemTab() {
    }

    public PccTailTaskProductItemTab(String name) {
        super(name);
    }

    public PccTailTaskProductItemTab(String name, String desc) {
        super(name, desc);
    }

    @Override
    public String returnComponentType() {
        return PccTailTaskProductItemTab.COMPONENT_TYPE;
    }

    public static PccTailTaskProductItemTab create(String tabName, List<Map<String, Object>> bizDataList,
                                                   String taskCategory, ApiRequest apiRequest, PccProjectTaskInfo taskInfo) {
        PccTailTaskProductItemTab tab = new PccTailTaskProductItemTab(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), tabName));
        PccTailTaskProductItemDataList pccTailTaskProductItemDataList = new PccTailTaskProductItemDataList();
        for (Map<String, Object> bizData : bizDataList) {
            /*Map<String, Object> docInfoMap = new HashMap<>();
            for (String key : responseValue.keySet()) {
                if ("MES".equalsIgnoreCase(taskCategory) && "status".equalsIgnoreCase(key)) {
                    key = "close_status";
                }
                String[] docInfoMapArr = {"close_status","purchase_no", "purchase_seq", "item_no", "item_name_spec"};
                if (MobileUiBotStringUtil.isHaveThisString(docInfoMapArr, key)) {
                    docInfoMap.put(key, responseValue.get(key));
                } else {
                    continue;
                }
            }*/

            pccTailTaskProductItemDataList.add(
                    PccTailTaskProductItemDataItem.create(apiRequest, bizData, taskInfo, taskCategory));
        }
        tab.setContent(pccTailTaskProductItemDataList);

        return tab;
    }

    public static PccTailTaskProductItemTab createKsc(String tabName, List<Map<String, Object>> bizDataList,
                                                      String taskCategory, ApiRequest apiRequest, PccProjectTaskInfo taskInfo) {
        PccTailTaskProductItemTab tab = new PccTailTaskProductItemTab(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), tabName));
        PccTailTaskProductItemDataList pccTailTaskProductItemDataList = new PccTailTaskProductItemDataList();
        for (Map<String, Object> bizData : bizDataList) {
            /*Map<String, Object> docInfoMap = new HashMap<>();
            for (String key : responseValue.keySet()) {
                if ("MES".equalsIgnoreCase(taskCategory) && "status".equalsIgnoreCase(key)) {
                    key = "close_status";
                }
                String[] docInfoMapArr = {"close_status","purchase_no", "purchase_seq", "item_no", "item_name_spec"};
                if (MobileUiBotStringUtil.isHaveThisString(docInfoMapArr, key)) {
                    docInfoMap.put(key, responseValue.get(key));
                } else {
                    continue;
                }
            }*/

            pccTailTaskProductItemDataList.add(
                    PccTailTaskProductItemDataItem.createKsc(apiRequest, bizData, taskInfo, taskCategory));
        }
        tab.setContent(pccTailTaskProductItemDataList);

        return tab;
    }
}
