package com.digiwin.mobile.mobileuibot.core.component.business.pcc;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.project.model.projectcc.ProjectCCTaskItem;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * <p>功能描述：项目中控台 PCC尾阶段任务详情头部组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PccTaskDetailSummary
 * @Author: Liux
 * @Date: 2022年5月12日 17点00分
 */
@Data
public class PccTaskDetailSummary extends ProjectCCTaskItem implements MobileComponent, Serializable {

    private static final long serialVersionUID = -4339161559713181815L;
    public static final String COMPONENT_TYPE = "PCC_TASK_DETAIL_SUMMARY";

    @Override
    public String returnComponentType() {
        return PccTaskDetailSummary.COMPONENT_TYPE;
    }

    public PccTaskDetailSummary() {
    }

    public static PccTaskDetailSummary create(String locale, PccProjectTaskInfo currentProjectTaskInfo,
                                              boolean isCrumbs, String iamUserToken, String projectNo) {
        ProjectCCTaskItem projectCCTaskItem = new PccTaskDetailSummary();
        PccTaskDetailSummary pccTaskDetailSummary = JsonUtil.objectToJavaObject(projectCCTaskItem.create(locale, currentProjectTaskInfo, new ArrayList<>(), isCrumbs, iamUserToken, projectNo, false), PccTaskDetailSummary.class);
        return pccTaskDetailSummary;
    }

    public static PccTaskDetailSummary createPccPlan(String locale, PccProjectTaskInfo currentProjectTaskInfo) {
        ProjectCCTaskItem projectCCTaskItem = new PccTaskDetailSummary();
        PccTaskDetailSummary pccTaskDetailSummary = JsonUtil.objectToJavaObject(projectCCTaskItem.createPccPlan(locale, currentProjectTaskInfo, new ArrayList<>()), PccTaskDetailSummary.class);
        return pccTaskDetailSummary;
    }

    public static PccTaskDetailSummary createKsc(String locale, PccProjectTaskInfo currentProjectTaskInfo,
                                                 boolean isCrumbs, String iamUserToken, String projectNo) {
        ProjectCCTaskItem projectCCTaskItem = new PccTaskDetailSummary();
        PccTaskDetailSummary pccTaskDetailSummary = JsonUtil.objectToJavaObject(projectCCTaskItem.createKscItem(locale, currentProjectTaskInfo, new ArrayList<>(), isCrumbs, iamUserToken, projectNo, false), PccTaskDetailSummary.class);
        return pccTaskDetailSummary;
    }

}
