package com.digiwin.mobile.mobileuibot.core.component.business.portal;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 *V2门户业务入口组件
 */
@Data
public class BusinessComponent extends BaseMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "SERVICE_ENTRY";
    private static final long serialVersionUID = 6491971829998038208L;

    /**
     *业务入口的样式
     */
    private Integer style;

    /**
     *业务入口背景颜色，格式为#RRGGBBAA，例如：#ff0000ff
     */
    private String backgroundColor;

    /**
     *图片数据
     */
    private List<BusinessImage> data;

    @Override
    public String returnComponentType() {
        return BusinessComponent.COMPONENT_TYPE;
    }
}
