package com.digiwin.mobile.mobileuibot.core.component.button;

import lombok.Getter;

/**
 * 签核按钮类型枚举
 */
@Getter
public enum ApprovalButtonTypeEnum {

    // 数据转派
    DATA_REASSIGNMENT_ACTION("data-reassignment-action"),

    // 签核：退回重办
    REEXECUTE("reexecute"),

    // 签核：退回重办
    ATHENA_BPM_REEXECUTE("athena_bpm_reexecute"),

    // 签核：同意
    AGREE("agree"),

    // 签核：不同意/终止
    DISAGREE("disagree"),

    // 签核：不同意/终止
    ATHENA_BPM_DISAGREE("athena_bpm_disagree"),


    // 签核：加签
    ADD_TASK("add-task"),

    // 签核：加签
    ATHENA_BPM_ADD_TASK("athena_bpm_add_task"),

    // 签核：退回重签
    REAPPROVE("reapprove"),

    // 签核：退回重签
    ATHENA_BPM_REAPPROVE("athena_bpm_reapprove");

    private String type;

    ApprovalButtonTypeEnum(String type) {
        this.type = type;
    }

    public static boolean isExist(String type) {
        for (ApprovalButtonTypeEnum approvalButtonypeEnum : values()) {
            if(approvalButtonypeEnum.getType().equals(type)) {
                return true;
            }
        }
        return false;
    }

    public static ApprovalButtonTypeEnum getEnumByType(String type) {
        for (ApprovalButtonTypeEnum approvalButtonypeEnum : values()) {
            if (approvalButtonypeEnum.getType().equals(type)) {
                return approvalButtonypeEnum;
            }
        }
        return null;
    }
}
