package com.digiwin.mobile.mobileuibot.core.component.button;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import io.micrometer.core.instrument.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BottomButtonBizApprovalBuilder
 * @Author: Zaregoto
 * @Date: 2021/5/23 17:30
 */
@Component("bottomButtonBizApprovalBuilder")
public class BottomButtonBizApprovalBuilder implements MobileComponentBuilder<BottomButtonList> {

    private static final Logger logger = LoggerFactory.getLogger(BottomButtonBizApprovalBuilder.class);

    @Override
    public String getMobileComponentType() {
//        return BottomButtonList.COMPONENT_TYPE;
        return BottomButtonDigiwinAthena.COMPONENT_TYPE;
    }

    @Override
    public BottomButtonList build(ApiRequest apiRequest, PageSetting pageSetting,
                                  UiBotModel pcUiBotModel,
                                  Class<BottomButtonList> clazz, Object... args) {
        String locale = apiRequest.getLocale();

        List<UiBotAction> uiBotActions = pcUiBotModel.getActions();
        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        // 获得实际业务的数据对象
        String bizDataSchema = "";
        UiBotTargetLayoutSearchResult layoutSearchResult = pcUiBotModel.searchPcTargetLayout();
        if (layoutSearchResult.found()) {
            bizDataSchema = layoutSearchResult.getTargetUiBotLayout().getSchema();
        } else {
            return BottomButtonList.createEmpty();
        }
        Object bizData = pcUiBotModel.getPageData().get(bizDataSchema);
        if (bizData == null) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof List) {
            if (((List<?>) bizData).isEmpty()) {
                return BottomButtonList.createEmpty();
            }
        }
        if (bizData instanceof Map) {
            if (((Map) bizData).isEmpty()) {
                return BottomButtonList.createEmpty();
            }
        }

        // 构造出一级按钮和下级按钮
        BottomButtonList result = new BottomButtonList();
        Map<String, UiBotAction> allActionMap = new HashMap<>();
        //2022年5月6日 方法重构，是页面按钮对象能封装到allActionMap中。
        //根据serviceId.name，按数据顺序整理出所有uibotaction对象
        for (UiBotAction uiBotAction : uiBotActions) {
            String serviceIdName = uiBotAction.getActionServiceIdName();
            if (uiBotAction.isAgreeAction(serviceIdName)) {
                allActionMap.put("dispatch", uiBotAction);
            } else if (uiBotAction.isReexecuteAction(serviceIdName)) {
                allActionMap.put("reexecute", uiBotAction);
            } else {
                String targetServiceIdName = uiBotAction.getUsefulActionServiceIdName();
                if (uiBotAction.isAgreeAction(targetServiceIdName)) {
                    allActionMap.put("dispatch", uiBotAction);
                } else if (uiBotAction.isReexecuteAction(targetServiceIdName)) {
                    allActionMap.put("reexecute", uiBotAction);
                } else {
                    allActionMap.put(targetServiceIdName, uiBotAction);
                }
            }
        }


        UiBotModel pageSettingModel = pageSetting.getPageModel();
        String bottomButtonDataSchema = pageSettingModel.getLayout().stream().filter(
                layout -> layout.getType().equalsIgnoreCase(this.getMobileComponentType())
        ).findFirst().orElse(new UiBotLayout()).getSchema();

        Map<String, Object> pageData = pageSettingModel.getPageData();
        JSONArray bottomButtonDataArray =
                (JSONArray) JSON.toJSON(pageData.get(bottomButtonDataSchema));
        //加签按钮添加应用参数appCode
        String appCode = null;
        if (!ObjectUtils.isEmpty(args)) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = (DigiwinAtmcBacklogDetail) args[0];
            appCode = digiwinAtmcBacklogDetail.getAppCode();
        }

        for (int i = 0; i < bottomButtonDataArray.size(); i++) {
            JSONObject bottomButtonJsonObj = bottomButtonDataArray.getJSONObject(i);
            String id = bottomButtonJsonObj.getString("id");

            BottomButtonDigiwinAthena bottomButton;
            if ("other".equalsIgnoreCase(id)) {
                // 手工造的 其他按钮
                bottomButton = BottomButtonDigiwinAthena.create(
                        BottomButtonStyleEnum.NORMAL.getValue(), "...");
            } else if ("redo".equalsIgnoreCase(id)) {
                // 手工造的 退回按钮
                bottomButton = BottomButtonDigiwinAthena.create(
                        BottomButtonStyleEnum.NORMAL.getValue(), LocaleUtil.getMobileTextByKey(locale, "退回"));
            } else {
                UiBotAction pcUiBotAction = allActionMap.get(id);
                //空判断，不为空则造按钮，为空的话不用造该按钮
                if (null != pcUiBotAction) {
                    // 同意按钮

                    // action获取
                    JSONObject buttonActionJsonObj = bottomButtonJsonObj.getJSONObject("action");
                    String jumpPageId = buttonActionJsonObj.getString("jumpPageId");
                    Integer buttonType = buttonActionJsonObj.getInteger("type");
                    bottomButton = BottomButtonDigiwinAthena.create(pcUiBotAction,
                            bizDataSchema, bizData, null,
                            new Action(jumpPageId,
                                    LocaleUtil.getMobileTextByKey(locale, jumpPageId),
                                    buttonType),
                            bottomButtonJsonObj.getInteger("iconData"), id, appCode);
                } else {
                    continue;
                }
            }
            JSONArray childrenBottomButtonArray = bottomButtonJsonObj.getJSONArray("children");
            for (int j = 0; null != childrenBottomButtonArray && j < childrenBottomButtonArray.size(); j++) {
                JSONObject childBottomButtonJsonObj = childrenBottomButtonArray.getJSONObject(j);
                String childBottomButtonId = childBottomButtonJsonObj.getString("id");
                UiBotAction childUiBotAction = allActionMap.get(childBottomButtonId);

                // FIXME 按钮会少，因为数据库中配置的和athena给的不一样
                if (null == childUiBotAction) {
                    continue;
                }

                // action获取
                JSONObject childBottomButtonActionJsonObj = childBottomButtonJsonObj.getJSONObject("action");
                String jumpPageId = childBottomButtonActionJsonObj.getString("jumpPageId");
                String jumpPageTitle = childBottomButtonActionJsonObj.getString("jumpPageTitle");
                Integer buttonType = childBottomButtonActionJsonObj.getInteger("type");
                jumpPageTitle = LocaleUtil.getMobileTextByKey(locale, jumpPageTitle);
                if (StringUtils.isBlank(jumpPageTitle)) {
                    jumpPageTitle = LocaleUtil.getMobileTextByKey(locale, jumpPageId);
                }
                BottomButtonDigiwinAthena childBottomButton;
                Action childBottomButtonAction = new Action(jumpPageId,
                        jumpPageTitle,
                        buttonType);

                // FIXME 写死的逻辑，只有退回重签需要这个签核进度的数据
                if (childBottomButtonId.equalsIgnoreCase("reapprove")) {
                    childBottomButton = BottomButtonDigiwinAthena.create(childUiBotAction,
                            bizDataSchema, bizData,
                            TaskDataExtractUtil.getSignoffProgressData(pcUiBotModel.getPageData()),
                            childBottomButtonAction,
                            childBottomButtonJsonObj.getInteger("iconData"), childBottomButtonId, appCode);
                } else {
                    childBottomButton = BottomButtonDigiwinAthena.create(childUiBotAction,
                            bizDataSchema, bizData, null,
                            childBottomButtonAction,
                            childBottomButtonJsonObj.getInteger("iconData"), childBottomButtonId, appCode);
                }
                ModuleUtils.addRefreshPageId(childBottomButton, apiRequest.getPageId());
                bottomButton.addChildBottomButton(childBottomButton);
            }

            //当该按钮配置了二层按钮，且二层按钮web端没有的时候则跳出本层循环
            int isHaveChildren = bottomButton.getChildren().size();
            if (null != childrenBottomButtonArray) {
                if (isHaveChildren == 0) {
                    continue;
                }
            } else {
                ModuleUtils.addRefreshPageId(bottomButton, apiRequest.getPageId());
            }

            result.add(bottomButton);
        }

        return result;
    }
}
