package com.digiwin.mobile.mobileuibot.core.component.button;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import io.micrometer.core.instrument.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BottomButtonBizReportBuilder
 * @Author: Zaregoto
 * @Date: 2021/5/23 17:30
 */
@Component("bottomButtonBizReportBuilder")
public class BottomButtonBizReportBuilder implements MobileComponentBuilder<BottomButtonList> {

    private static final Logger logger = LoggerFactory.getLogger(BottomButtonBizReportBuilder.class);

    /**
     * FIXME 移动端button与pc端button的关系。后面要改成从数据库读取
     * key-pc端按钮id
     * value-移动端按钮id
     */
    public static final Map<String, String> BUTTON_MAP = new HashMap<>();

    public BottomButtonBizReportBuilder() {
        BUTTON_MAP.put("esp_task.info.update", "submit");
        BUTTON_MAP.put("esp_upload.personnel.attachment.info.create", "submit");
        //管理异常套件任务卡
        BUTTON_MAP.put("start-new-process", "submit");
        BUTTON_MAP.put("submit-data", "submit");

        //FIXME 乾冶客制 目前有问题，两个按钮actionId一样
        BUTTON_MAP.put("esp_uc.task.info.update", "complete_submit");
//        BUTTON_MAP.put("esp_uc.task.info.update", "report_submit");

        // pcc手动任务-撤回
        BUTTON_MAP.put("esp_bm.pisc.task.update", "submit");
    }

    @Override
    public String getMobileComponentType() {
        return BottomButtonDigiwinAthena.COMPONENT_TYPE;
    }

    @Override
    public BottomButtonList build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                  Class<BottomButtonList> clazz, Object... args) {
        BottomButtonList result = new BottomButtonList();
        switch (PageSettingIdPresetEnum.getEnumByName(pageSetting.getPageId())) {
            case MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_LIST:
                result = buildProjectScheduleReport(apiRequest, pageSetting, pcUiBotModel, clazz, args);
                break;
            case MOBILE_MY_BIZ_REPORT_TASK_DETAIL_QIANYE_UC:
                result = buildReportQianyeUc(apiRequest, pageSetting, pcUiBotModel, clazz, args);
                break;
            default:
                result = buildDefault(apiRequest, pageSetting, pcUiBotModel, clazz, args);
                break;
        }
        return result;
    }

    public BottomButtonList buildDefault(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                         Class<BottomButtonList> clazz, Object... args) {
        List<UiBotAction> uiBotActions = pcUiBotModel.getActions();
        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        // 获得实际业务的数据对象：layout中schema=id的那个layout，schema就是。
        String bizDataSchema = pcUiBotModel.searchBizDataSchema();
        Object bizData = pcUiBotModel.getPageData().get(bizDataSchema);
        if (bizData == null) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof List) {
            if (((List<?>) bizData).isEmpty()) {
                return BottomButtonList.createEmpty();
            }
        }
        if (bizData instanceof Map) {
            if (((Map) bizData).isEmpty()) {
                return BottomButtonList.createEmpty();
            }
        }
        // 依PCUiBot的内容，构造移动端底部按钮
        BottomButtonList result = new BottomButtonList();

        UiBotModel pageSettingModel = pageSetting.getPageModel();
        String bottomButtonDataSchema = pageSettingModel.getLayout().stream().filter(
                layout -> layout.getType().equalsIgnoreCase(this.getMobileComponentType())
        ).findFirst().orElse(new UiBotLayout()).getSchema();

        Map<String, Object> pageData = pageSettingModel.getPageData();
        JSONArray bottomButtonDataArray =
                (JSONArray) JSON.toJSON(pageData.get(bottomButtonDataSchema));
        for (int i = 0; i < bottomButtonDataArray.size(); i++) {
            JSONObject bottomButtonJsonObj = bottomButtonDataArray.getJSONObject(i);
            String id = bottomButtonJsonObj.getString("id");
            Optional<UiBotAction> optPcUiBotAction = uiBotActions.stream().filter(
                    uiBotAction -> this.BUTTON_MAP.containsKey(uiBotAction.getActionId())
            ).findFirst();

            if (!optPcUiBotAction.isPresent()) {
                continue;
            }
            UiBotAction pcUiBotAction = optPcUiBotAction.get();

            // pageSetting配置的按钮id与本对象buttonMap中的value不匹配时，表示配置错误，也不展示按钮
            if (!id.equalsIgnoreCase(this.BUTTON_MAP.get(pcUiBotAction.getActionId()))) {
                continue;
            }

            BottomButtonDigiwinAthena bottomButton;
            JSONObject buttonActionJsonObj = bottomButtonJsonObj.getJSONObject("action");
            Integer buttonType = buttonActionJsonObj.getInteger("type");
            bottomButton = BottomButtonDigiwinAthena.create(pcUiBotAction,
                    bizDataSchema, bizData, null, new Action(buttonType));
            // 管理异常套件任务卡,rawData里加action所需参数
            if (bottomButton.getAction().getRawData() instanceof ButtonRawData) {
                ButtonRawData buttonRawData = (ButtonRawData) bottomButton.getAction().getRawData();
                Map<String, Object> map = buttonRawData.getData();
                if (pcUiBotAction.getSubmitType() != null && StringUtils.isNotBlank(pcUiBotAction.getSubmitType().getSchema())) {
                    String schema = pcUiBotAction.getSubmitType().getSchema();
                    map.put(schema, pcUiBotModel.getPageData().get(schema));
                }
            }
            result.add(bottomButton);
        }
        ModuleUtils.addRefreshPageId(result, "");
        return result;
    }

    //TODO 已经作废不使用了，2022年7月13日11点17分
    public BottomButtonList buildProjectScheduleReport(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                                       Class<BottomButtonList> clazz, Object... args) {
        BottomButtonList result = new BottomButtonList();
        BottomButtonDigiwinAthena submitButton = new BottomButtonDigiwinAthena();
        submitButton.setName(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "提交"));
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("actionId", "aaaaaa");

        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
        buttonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/projectScheduleReport/projectScheduleSubmin");
        buttonAction.setRawData(rawData);
        submitButton.setAction(buttonAction);

        submitButton.setType(BottomButtonStyleEnum.DETAIL_NORMAL.getValue());
        result.add(submitButton);

        return result;
    }

    public BottomButtonList buildReportQianyeUc(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                                Class<BottomButtonList> clazz, Object... args) {
        List<UiBotAction> uiBotActions = pcUiBotModel.getActions();
        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        // 获得实际业务的数据对象：layout中schema=id的那个layout，schema就是。
        String bizDataSchema = pcUiBotModel.searchBizDataSchema();
        Object bizData = pcUiBotModel.getPageData().get(bizDataSchema);
        if (bizData == null) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof List) {
            if (((List<?>) bizData).isEmpty()) {
                return BottomButtonList.createEmpty();
            }
        }
        if (bizData instanceof Map) {
            if (((Map) bizData).isEmpty()) {
                return BottomButtonList.createEmpty();
            }
        }
        // 依PCUiBot的内容，构造移动端底部按钮
        BottomButtonList result = new BottomButtonList();

        UiBotModel pageSettingModel = pageSetting.getPageModel();
        String bottomButtonDataSchema = pageSettingModel.getLayout().stream().filter(
                layout -> layout.getType().equalsIgnoreCase(this.getMobileComponentType())
        ).findFirst().orElse(new UiBotLayout()).getSchema();

        Map<String, Object> pageData = pageSettingModel.getPageData();
        JSONArray bottomButtonDataArray =
                (JSONArray) JSON.toJSON(pageData.get(bottomButtonDataSchema));
        if (CollectionUtils.isEmpty(bottomButtonDataArray)) {
            for (UiBotAction uiBotAction : uiBotActions) {
                BottomButtonDigiwinAthena bottomButton;
                bottomButton = BottomButtonDigiwinAthena.create(uiBotAction,
                        bizDataSchema, bizData, null, new Action(3));
                result.add(bottomButton);
            }
        } else {
            for (int i = 0; i < bottomButtonDataArray.size(); i++) {
                JSONObject bottomButtonJsonObj = bottomButtonDataArray.getJSONObject(i);
                String id = bottomButtonJsonObj.getString("id");
                Optional<UiBotAction> optPcUiBotAction = uiBotActions.stream().filter(
                        uiBotAction -> this.BUTTON_MAP.containsKey(uiBotAction.getActionId())
                ).findFirst();

                if (!optPcUiBotAction.isPresent()) {
                    continue;
                }
                UiBotAction pcUiBotAction = optPcUiBotAction.get();

                // pageSetting配置的按钮id与本对象buttonMap中的value不匹配时，表示配置错误，也不展示按钮
                if (!id.equalsIgnoreCase(this.BUTTON_MAP.get(pcUiBotAction.getActionId()))) {
                    continue;
                }

                BottomButtonDigiwinAthena bottomButton;
                JSONObject buttonActionJsonObj = bottomButtonJsonObj.getJSONObject("action");
                Integer buttonType = buttonActionJsonObj.getInteger("type");
                bottomButton = BottomButtonDigiwinAthena.create(pcUiBotAction,
                        bizDataSchema, bizData, null, new Action(buttonType));
                // 管理异常套件任务卡,rawData里加action所需参数
                if (bottomButton.getAction().getRawData() instanceof ButtonRawData) {
                    ButtonRawData buttonRawData = (ButtonRawData) bottomButton.getAction().getRawData();
                    Map<String, Object> map = buttonRawData.getData();
                    if (pcUiBotAction.getSubmitType() != null && StringUtils.isNotBlank(pcUiBotAction.getSubmitType().getSchema())) {
                        String schema = pcUiBotAction.getSubmitType().getSchema();
                        map.put(schema, pcUiBotModel.getPageData().get(schema));
                    }
                }
                result.add(bottomButton);
            }
        }
        ModuleUtils.addRefreshPageId(result, "");
        return result;
    }

}
